/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.IFunction;
import hep.aida.ext.IVariable;
import java.util.Hashtable;

public abstract class AbstractModelFunction
implements IFunction {
    private int dimension;
    private int numbOfPars;
    private String name = "AbstractModelFunction";
    private Hashtable varHash = new Hashtable();
    private Hashtable parHash = new Hashtable();
    private IVariable[] parameters;
    private IVariable[] variables;

    public int dimension() {
        return this.dimension;
    }

    public String label() {
        return "Model Function : " + this.name;
    }

    public double parameter(String str) {
        Object par = this.parHash.get(str);
        if (par != null) {
            return ((IVariable)par).value();
        }
        throw new IllegalArgumentException("Parameter " + str + " does not belong to this " + this.name);
    }

    public String[] parameterNames() {
        String[] names = new String[this.numbOfPars];
        for (int i = 0; i < this.numbOfPars; ++i) {
            names[i] = this.parameters[i].name();
        }
        return names;
    }

    public double[] parameterValues() {
        double[] values = new double[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            values[i] = this.parameters[i].value();
        }
        return values;
    }

    public double[] parameters() {
        throw new UnsupportedOperationException();
    }

    public abstract void setNormalization(double var1);

    public boolean supportsNormalization() {
        return false;
    }

    public abstract double value() throws IllegalArgumentException;

    public double value(double[] values) throws IllegalArgumentException {
        for (int i = 0; i < this.dimension; ++i) {
            this.variables[i].setValue(values[i]);
        }
        return this.value();
    }

    public double value(double[] values, double[] parValues) throws IllegalArgumentException {
        int count = 0;
        for (int i = 0; i < this.numbOfPars; ++i) {
            if (this.parameters[i].isFixed()) continue;
            this.parameters[i].setValue(parValues[count++]);
        }
        return this.value(values);
    }

    public IVariable variable(String str) {
        Object var = this.varHash.get(str);
        if (var != null) {
            return (IVariable)var;
        }
        throw new IllegalArgumentException("Variable " + str + " does not belong to this " + this.name);
    }

    public IVariable[] variables() {
        return this.variables;
    }
}

