/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.fitter.fitMethod;

import hep.aida.IFunction;
import hep.aida.IModelFunction;
import hep.aida.dev.IDevFitDataIterator;
import hep.aida.ref.fitter.fitMethod.IFitMethod;

public class CleverChiSquaredFitMethod
implements IFitMethod {
    public double evaluateSumElement(IDevFitDataIterator dataIter, IFunction function) {
        double fVal = function.value(dataIter.vars());
        return Math.pow(dataIter.value() - fVal, 2.0) / Math.abs(fVal);
    }

    public int fitType() {
        return 0;
    }

    public boolean providesGradientSumElement() {
        return true;
    }

    public double[] evaluateGradientSumElement(IDevFitDataIterator dataIter, IFunction function) {
        double f = function.value(dataIter.vars());
        double[] der = ((IModelFunction)function).parameterGradient(dataIter.vars());
        double[] newDer = new double[der.length];
        double val = dataIter.value();
        double d = val - f;
        double s = f > 0.0 ? 1.0 : -1.0;
        double c = d * (-2.0 * Math.abs(f) - d * s) / (f * f);
        for (int i = 0; i < der.length; ++i) {
            newDer[i] = der[i] * c;
        }
        return newDer;
    }
}

