/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref;

import hep.aida.IAnalysisFactory;
import hep.aida.IDataPointSetFactory;
import hep.aida.IFitFactory;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogramFactory;
import hep.aida.IPlotterFactory;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.ITupleFactory;
import hep.aida.ref.fitter.FitFactory;
import hep.aida.ref.fitter.fitMethod.BinnedMaximumLikelihoodFitMethod;
import hep.aida.ref.fitter.fitMethod.ChiSquaredFitMethod;
import hep.aida.ref.fitter.fitMethod.CleverChiSquaredFitMethod;
import hep.aida.ref.fitter.fitMethod.LeastSquaresFitMethod;
import hep.aida.ref.fitter.fitMethod.UnbinnedMaximumLikelihoodFitMethod;
import hep.aida.ref.function.FunctionFactory;
import hep.aida.ref.histogram.DataPointSetFactory;
import hep.aida.ref.histogram.HistogramFactory;
import hep.aida.ref.optimizer.minuit.MinuitOptimizerFactory;
import hep.aida.ref.optimizer.uncmin.UncminOptimizerFactory;
import hep.aida.ref.plotter.DummyPlotterFactory;
import hep.aida.ref.tree.TreeFactory;
import hep.aida.ref.tuple.TupleFactory;
import org.freehep.util.FreeHEPLookup;

public class BatchAnalysisFactory
extends IAnalysisFactory {
    public ITreeFactory createTreeFactory() {
        return new TreeFactory(this);
    }

    public IHistogramFactory createHistogramFactory(ITree tree) {
        return new HistogramFactory(tree);
    }

    public ITupleFactory createTupleFactory(ITree tree) {
        return new TupleFactory(tree);
    }

    public IFunctionFactory createFunctionFactory(ITree tree) {
        return new FunctionFactory(tree);
    }

    public IPlotterFactory createPlotterFactory() {
        return new DummyPlotterFactory();
    }

    public IDataPointSetFactory createDataPointSetFactory(ITree iTree) {
        return new DataPointSetFactory(iTree);
    }

    public IFitFactory createFitFactory() {
        return new FitFactory();
    }

    static {
        FreeHEPLookup.instance().add((Object)new UncminOptimizerFactory(), "uncmin");
        FreeHEPLookup.instance().add((Object)new MinuitOptimizerFactory(), "minuit");
        FreeHEPLookup.instance().add((Object)new LeastSquaresFitMethod(), new String[]{"leastsquares", "ls"});
        FreeHEPLookup.instance().add((Object)new ChiSquaredFitMethod(), new String[]{"chi2", "chisquared"});
        FreeHEPLookup.instance().add((Object)new CleverChiSquaredFitMethod(), new String[]{"cleverchi2", "cleverchisquared"});
        FreeHEPLookup.instance().add((Object)new BinnedMaximumLikelihoodFitMethod(), new String[]{"bml", "binnedmaxlikelihood", "binnedmaximumlikelihood"});
        FreeHEPLookup.instance().add((Object)new UnbinnedMaximumLikelihoodFitMethod(), new String[]{"uml", "unbinnedmaxlikelihood", "unbinnedmaximumlikelihood"});
        FreeHEPLookup.instance().add((Object)new hep.tuple.TupleFactory(), "FTupleFactory");
    }
}

