/*
 * Decompiled with CFR 0.152.
 */
package TestGUI;

import GuiComponents.Console.JConsole;
import GuiComponents.scripting.BeanShellFactory;
import GuiComponents.scripting.DefaultInterpreter;
import GuiComponents.scripting.JavaScriptFactory;
import GuiComponents.scripting.JythonFactory;
import GuiComponents.scripting.NameCompleter;
import GuiComponents.scripting.ScriptFactory;
import GuiComponents.scripting.SearchableObjectRegistry;
import TestGUI.MyJPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.ObjectRegistry;

public class ScriptingInterface
extends JPanel {
    protected BSFManager manager = new BSFManager();
    protected JConsole console;
    protected SearchableObjectRegistry registry;
    private JButton bBeanShell;
    private JButton bJavaScript;
    private JButton bJython;
    private JPanel jButtonPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;

    public ScriptingInterface(MyJPanel myJPanel) {
        this.initComponents();
        this.initMyComponents();
        this.initManager(myJPanel);
    }

    private void initComponents() {
        this.jButtonPanel = new JPanel();
        this.bJavaScript = new JButton();
        this.bBeanShell = new JButton();
        this.bJython = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.setLayout(new BorderLayout());
        this.jButtonPanel.setLayout(new GridBagLayout());
        this.bJavaScript.setText("JavaScript");
        this.bJavaScript.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScriptingInterface.this.bJavaScriptActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jButtonPanel.add((Component)this.bJavaScript, gridBagConstraints);
        this.bBeanShell.setText("BeanShell");
        this.bBeanShell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScriptingInterface.this.bBeanShellActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jButtonPanel.add((Component)this.bBeanShell, gridBagConstraints);
        this.bJython.setText("Jython");
        this.bJython.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScriptingInterface.this.bJythonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jButtonPanel.add((Component)this.bJython, gridBagConstraints);
        this.jLabel1.setText("Create new scripting console...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jButtonPanel.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jButtonPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.add((Component)this.jButtonPanel, "Center");
    }

    private void bJythonActionPerformed(ActionEvent actionEvent) {
        this.createScriptInterface(new JythonFactory());
    }

    private void initMyComponents() {
    }

    private void initManager(MyJPanel myJPanel) {
        this.registry = new SearchableObjectRegistry();
        this.manager.setObjectRegistry((ObjectRegistry)this.registry);
        try {
            this.manager.declareBean("sctPanel", (Object)myJPanel, myJPanel.getClass());
            this.manager.declareBean("sct", (Object)myJPanel.si, myJPanel.si.getClass());
        }
        catch (BSFException bSFException) {
            System.err.println("Error initializing manager: " + (Object)((Object)bSFException));
        }
    }

    private void bBeanShellActionPerformed(ActionEvent actionEvent) {
        this.createScriptInterface(new BeanShellFactory());
    }

    private void bJavaScriptActionPerformed(ActionEvent actionEvent) {
        this.createScriptInterface(new JavaScriptFactory());
    }

    protected void createScriptInterface(ScriptFactory scriptFactory) {
        JConsole jConsole = scriptFactory.createConsole();
        try {
            this.manager.declareBean("console", (Object)jConsole, jConsole.getClass());
        }
        catch (BSFException bSFException) {
            System.err.println("Internal error, BSFException whilst adding bean console.\n" + (Object)((Object)bSFException));
            bSFException.printStackTrace();
        }
        BSFEngine bSFEngine = scriptFactory.createEngine(this.manager);
        NameCompleter nameCompleter = scriptFactory.createNameCompleter(bSFEngine, this.registry);
        DefaultInterpreter defaultInterpreter = scriptFactory.createInterpreter(bSFEngine, jConsole, nameCompleter);
        this.addNewConsole(jConsole, defaultInterpreter.toString());
    }

    protected boolean addNewConsole(JConsole jConsole, String string) {
        if (this.console != null) {
            MyJPanel.getMessageArea().append("Can only have 1 scripting window open at once\n");
            return false;
        }
        this.console = jConsole;
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ScriptingInterface.this.removeConsole();
            }
        });
        jFrame.getContentPane().add(jConsole);
        jFrame.setTitle("Scripting Window:" + string);
        jFrame.show();
        jFrame.setSize(400, 500);
        return true;
    }

    protected void removeConsole() {
        try {
            this.manager.undeclareBean("console");
        }
        catch (BSFException bSFException) {
            System.err.println("Internal error, BSFException whilst removing bean console.\n" + (Object)((Object)bSFException));
            bSFException.printStackTrace();
        }
        this.console = null;
    }
}

