/*
 * Decompiled with CFR 0.152.
 */
package TestGUI;

import GuiComponents.System.ISInterface;
import GuiComponents.System.SystemInterface;
import Sct.Version;
import SctApiTest.sctapi;
import TestGUI.CalibrationControllerPanel;
import TestGUI.ISPanel;
import TestGUI.MRSPanel;
import TestGUI.ScriptingInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;

public class MyJPanel
extends JPanel {
    protected static JTextArea taOutput;
    private JButton b3Gain;
    private JButton bAbout;
    private JButton bApiPing;
    private JButton bBypass;
    private JButton bExit;
    private JButton bGC;
    private JButton bInitialize;
    private JButton bNoise;
    private JButton bPipeline;
    private JButton bRefresh;
    private JButton bResponse;
    private JButton bStobe;
    private JButton bTimeWalk;
    private JButton bTrim;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSplitPane jSplitPane1;
    private JLabel lOutput;
    private JPanel pAPI;
    private JTabbedPane tpTabs;
    private ISPanel pIS;
    private MRSPanel pMRS;
    private CalibrationControllerPanel pCC;
    SystemInterface si;
    ISInterface is;
    ScriptingInterface scripting;

    public MyJPanel() {
        this.initComponents();
        this.myInitComponents();
    }

    private void exit() {
        this.pIS.close();
        this.pMRS.close();
        this.pCC.close();
        System.exit(0);
    }

    private void myInitComponents() {
        taOutput = new JTextArea(){

            public void append(String string) {
                super.append(string);
                this.setCaretPosition(this.getText().length());
            }
        };
        taOutput.setEditable(false);
        taOutput.setBorder(new EtchedBorder());
        this.jScrollPane1.setViewportView(taOutput);
        this.si = SystemInterface.getInstance();
        this.is = ISInterface.getInstance();
        this.pIS = new ISPanel(taOutput);
        this.pMRS = new MRSPanel(taOutput);
        this.pCC = new CalibrationControllerPanel(taOutput);
        this.scripting = new ScriptingInterface(this);
        this.tpTabs.insertTab("IS", null, this.pIS, "IS Servers in Partition SCT", 0);
        this.tpTabs.insertTab("MRS", null, this.pMRS, "MRS Messages for Partition SCT", 1);
        this.tpTabs.insertTab("CalibrationController", null, this.pCC, "Interface to Calibration Controller", 2);
        this.tpTabs.addTab("Scripting", null, this.scripting, "Gives command line access in a choice of languages");
    }

    public static JTextArea getMessageArea() {
        return taOutput;
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.tpTabs = new JTabbedPane();
        this.pAPI = new JPanel();
        this.bInitialize = new JButton();
        this.bRefresh = new JButton();
        this.bPipeline = new JButton();
        this.bTrim = new JButton();
        this.bStobe = new JButton();
        this.bApiPing = new JButton();
        this.jSeparator1 = new JSeparator();
        this.bNoise = new JButton();
        this.b3Gain = new JButton();
        this.bResponse = new JButton();
        this.jLabel1 = new JLabel();
        this.bBypass = new JButton();
        this.bTimeWalk = new JButton();
        this.jPanel1 = new JPanel();
        this.lOutput = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel2 = new JPanel();
        this.bAbout = new JButton();
        this.bGC = new JButton();
        this.bExit = new JButton();
        this.setLayout(new GridBagLayout());
        this.jSplitPane1.setDividerLocation(400);
        this.jSplitPane1.setOrientation(0);
        this.pAPI.setLayout(new GridBagLayout());
        this.pAPI.setName("API");
        this.bInitialize.setText("Initialize");
        this.bInitialize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MyJPanel.this.bInitializeActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pAPI.add((Component)this.bInitialize, gridBagConstraints);
        this.bRefresh.setText("Refresh");
        this.bRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MyJPanel.this.bRefreshActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pAPI.add((Component)this.bRefresh, gridBagConstraints);
        this.bPipeline.setText("Pipeline Test");
        this.bPipeline.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MyJPanel.this.bPipelineActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pAPI.add((Component)this.bPipeline, gridBagConstraints);
        this.bTrim.setText("Trim Range");
        this.bTrim.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MyJPanel.this.bTrimActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pAPI.add((Component)this.bTrim, gridBagConstraints);
        this.bStobe.setText("Strobe Delay");
        this.bStobe.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MyJPanel.this.bStobeActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pAPI.add((Component)this.bStobe, gridBagConstraints);
        this.bApiPing.setText("Ping");
        this.bApiPing.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MyJPanel.this.bApiPingActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pAPI.add((Component)this.bApiPing, gridBagConstraints);
        this.jSeparator1.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pAPI.add((Component)this.jSeparator1, gridBagConstraints);
        this.bNoise.setText("Noise");
        this.bNoise.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MyJPanel.this.bNoiseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pAPI.add((Component)this.bNoise, gridBagConstraints);
        this.b3Gain.setText("3 Point Gain");
        this.b3Gain.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MyJPanel.this.b3GainActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pAPI.add((Component)this.b3Gain, gridBagConstraints);
        this.bResponse.setText("Response Curve");
        this.bResponse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MyJPanel.this.bResponseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pAPI.add((Component)this.bResponse, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pAPI.add((Component)this.jLabel1, gridBagConstraints);
        this.bBypass.setText("Full Bypass");
        this.bBypass.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MyJPanel.this.bBypassActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pAPI.add((Component)this.bBypass, gridBagConstraints);
        this.bTimeWalk.setText("Time Walk");
        this.bTimeWalk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MyJPanel.this.bTimeWalkActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pAPI.add((Component)this.bTimeWalk, gridBagConstraints);
        this.tpTabs.addTab("API", null, this.pAPI, "Controls the test SCTAPI interface");
        this.jSplitPane1.setTopComponent(this.tpTabs);
        this.jPanel1.setLayout(new BorderLayout());
        this.lOutput.setText("Output");
        this.jPanel1.add((Component)this.lOutput, "North");
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jSplitPane1.setBottomComponent(this.jPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jSplitPane1, gridBagConstraints);
        this.jPanel2.setLayout(new FlowLayout(2));
        this.bAbout.setText("About");
        this.bAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MyJPanel.this.bAboutActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.bAbout);
        this.bGC.setText("GC");
        this.bGC.setMaximumSize(new Dimension(57, 32));
        this.bGC.setMinimumSize(new Dimension(57, 32));
        this.bGC.setPreferredSize(new Dimension(57, 32));
        this.bGC.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MyJPanel.this.bGCActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.bGC);
        this.bExit.setText("Exit");
        this.bExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MyJPanel.this.bExitActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.bExit);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void bTimeWalkActionPerformed(ActionEvent actionEvent) {
        sctapi sctapi2 = this.si.getTestApi();
        if (sctapi2 != null) {
            sctapi2.doTimeWalkScan();
            taOutput.append("Requesting sct_api_server do a timewalk scan\n");
        } else {
            taOutput.append("SCTTestAPI not present\n");
        }
    }

    private void bBypassActionPerformed(ActionEvent actionEvent) {
        sctapi sctapi2 = this.si.getTestApi();
        if (sctapi2 != null) {
            sctapi2.doFullBypassScan();
            taOutput.append("Requesting sct_api_server do a full bypass scan\n");
        } else {
            taOutput.append("SCTTestAPI not present\n");
        }
    }

    private void bAboutActionPerformed(ActionEvent actionEvent) {
        String string = Version.instance.getAllInformation();
        String string2 = "TestGUI is a simple user interface for developers and is also used as a testbed for new developments.";
        string2 = string2 + "\nIt comes with no instructions or warranties, but may be useful for some purposes!";
        string2 = string2 + "\nTestGUI Author: Matthew Palmer.";
        string2 = string2 + "\nSctDaqRod Authors: Alan Barr, Bruce Gallop, Matthew Palmer, Dave Robinson and Alexander Tricoli";
        string2 = string2 + "\n\n" + string;
        JOptionPane.showMessageDialog(this, string2, "About TestGUI", 1);
    }

    private void bInitializeActionPerformed(ActionEvent actionEvent) {
        sctapi sctapi2 = this.si.getTestApi();
        if (sctapi2 != null) {
            sctapi2.initialise();
            taOutput.append("API initialized\n");
        } else {
            taOutput.append("SCTTestAPI not present\n");
        }
    }

    private void bRefreshActionPerformed(ActionEvent actionEvent) {
        this.si.refresh();
    }

    private void bPipelineActionPerformed(ActionEvent actionEvent) {
        sctapi sctapi2 = this.si.getTestApi();
        if (sctapi2 != null) {
            sctapi2.doPipelineScan();
            taOutput.append("Requesting sct_api_server do a pipeline scan\n");
        } else {
            taOutput.append("SCTTestAPI not present\n");
        }
    }

    private void bTrimActionPerformed(ActionEvent actionEvent) {
        sctapi sctapi2 = this.si.getTestApi();
        if (sctapi2 != null) {
            sctapi2.doTrimScan();
            taOutput.append("Requesting sct_api_server do a trim range scan\n");
        } else {
            taOutput.append("SCTTestAPI not present\n");
        }
    }

    private void bStobeActionPerformed(ActionEvent actionEvent) {
        sctapi sctapi2 = this.si.getTestApi();
        if (sctapi2 != null) {
            sctapi2.doStrobeDelayScan();
            taOutput.append("Requesting sct_api_server do a strobe delay scan\n");
        } else {
            taOutput.append("SCTTestAPI not present\n");
        }
    }

    private void bApiPingActionPerformed(ActionEvent actionEvent) {
        sctapi sctapi2 = this.si.getTestApi();
        if (sctapi2 != null) {
            taOutput.append(sctapi2.ping("") + "\n");
        } else {
            taOutput.append("SCTTestAPI not present\n");
        }
    }

    private void bNoiseActionPerformed(ActionEvent actionEvent) {
        sctapi sctapi2 = this.si.getTestApi();
        if (sctapi2 != null) {
            sctapi2.doNoiseScan();
            taOutput.append("Requesting sct_api_server do a noise scan\n");
        } else {
            taOutput.append("SCTTestAPI not present\n");
        }
    }

    private void b3GainActionPerformed(ActionEvent actionEvent) {
        sctapi sctapi2 = this.si.getTestApi();
        if (sctapi2 != null) {
            sctapi2.doThreePointGainScan();
            taOutput.append("Requesting sct_api_server do a 3 pt gain scan\n");
        } else {
            taOutput.append("SCTTestAPI not present\n");
        }
    }

    private void bResponseActionPerformed(ActionEvent actionEvent) {
        sctapi sctapi2 = this.si.getTestApi();
        if (sctapi2 != null) {
            sctapi2.doResponseCurveScan();
            taOutput.append("Requesting sct_api_server do a response curve scan\n");
        } else {
            taOutput.append("SCTTestAPI not present\n");
        }
    }

    private void bGCActionPerformed(ActionEvent actionEvent) {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory();
        long l2 = runtime.maxMemory();
        long l3 = runtime.totalMemory();
        taOutput.append("Total Mem: " + (double)l3 / 1024.0 + ", Max Mem:" + (double)l2 / 1024.0 + " , Free Mem: " + (double)l / 1024.0 + "\n");
        runtime.gc();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        runtime.gc();
        l = runtime.freeMemory();
        l2 = runtime.maxMemory();
        l3 = runtime.totalMemory();
        taOutput.append("Total Mem: " + (double)l3 / 1024.0 + ", Max Mem:" + (double)l2 / 1024.0 + " , Free Mem: " + (double)l / 1024.0 + "\n");
    }

    private void bExitActionPerformed(ActionEvent actionEvent) {
        this.exit();
    }
}

