/*
 * Decompiled with CFR 0.152.
 */
package TestGUI;

import GuiComponents.Inspector.InspectorPanel;
import GuiComponents.System.SystemInterface;
import Sct.Serializable;
import Sct.SerializableWrapper;
import Sct.Streamable;
import SctData.ModuleConfiguration;
import Sct_SctApi.SctApi;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import sctConf.ABCDModule;
import sctConf.Configuration;
import sctConf.ConfigurationException;

public class ModuleConfigurationPanel
extends JPanel {
    private String serialNo;
    private ModuleConfiguration currentModuleConfig;
    private InspectorPanel currentIP;
    private ModuleConfiguration savedModuleConfig;
    private InspectorPanel savedIP;
    private ButtonGroup buttonGroup1;
    private JRadioButton currentConfigButton;
    private JButton saveConfigButton;
    private JScrollPane scrollPane;
    private JRadioButton storedConfigButton;
    private JTextArea defaultText;
    private JLabel title;

    public ModuleConfigurationPanel(String string) {
        this.serialNo = string;
        this.initComponents();
    }

    private void getCurrentModuleConfig() {
        if (this.currentModuleConfig != null && this.currentIP != null) {
            return;
        }
        SctApi sctApi = SystemInterface.getInstance().getSctApi();
        if (sctApi == null) {
            Logger.getLogger("TestGUI").info("ModuleConfigurationPanel unable to get SctApi - so no data!");
            return;
        }
        try {
            int n = sctApi.findModuleSerial(this.serialNo);
            ABCDModule aBCDModule = sctApi.retrieveModule(n);
            this.currentModuleConfig = new ModuleConfiguration(aBCDModule);
            this.currentIP = new InspectorPanel("Module Configuration " + this.serialNo, (Serializable)new SerializableWrapper((Streamable)this.currentModuleConfig, this.serialNo, "ModuleConfiguration"));
        }
        catch (Exception exception) {
            Logger.getLogger("TestGUI").info("ConfigurationException whilst ModuleConfigurationPanel getting saved Module Configuration: " + exception.getMessage());
            return;
        }
    }

    private void getSavedModuleConfig() {
        if (this.savedModuleConfig != null && this.savedIP != null) {
            return;
        }
        Configuration configuration = SystemInterface.getInstance().getConfigurationService();
        if (configuration == null) {
            Logger.getLogger("TestGUI").info("ModuleConfigurationPanel unable to get ConfigurationService - so no data!");
            return;
        }
        try {
            ABCDModule aBCDModule = configuration.getModuleConfig(this.serialNo);
            this.savedModuleConfig = new ModuleConfiguration(aBCDModule);
            this.savedIP = new InspectorPanel("Module Configuration " + this.serialNo, (Serializable)new SerializableWrapper((Streamable)this.savedModuleConfig, this.serialNo, "ModuleConfiguration"));
        }
        catch (ConfigurationException configurationException) {
            Logger.getLogger("TestGUI").info("ConfigurationException whilst ModuleConfigurationPanel getting current Module Configuration: " + configurationException.getMessage());
            return;
        }
    }

    private void updateConfiguration() {
        int n = JOptionPane.showConfirmDialog(this, "This will update the configuration for all modules but it is NOT persistent.\nAre you sure?", "Configuration Update", 0);
        if (n != 0) {
            return;
        }
        SctApi sctApi = SystemInterface.getInstance().getSctApi();
        if (sctApi == null) {
            Logger.getLogger("TestGUI").info("ModuleConfigurationPanel unable to get SctApi - so no data!");
            return;
        }
        try {
            sctApi.storeModuleConfigurations();
        }
        catch (Exception exception) {
            Logger.getLogger("TestGUI").info("ConfigurationException whilst ModuleConfigurationPanel getting saved Module Configuration: " + exception.getMessage());
            return;
        }
    }

    private void initComponents() {
        this.setBackground(new Color(255, 255, 255));
        this.defaultText = new JTextArea("Configuration data not available");
        this.defaultText.setMinimumSize(new Dimension(500, 400));
        this.defaultText.setPreferredSize(new Dimension(600, 600));
        this.scrollPane = new JScrollPane(this.defaultText);
        this.saveConfigButton = new JButton();
        this.storedConfigButton = new JRadioButton();
        this.storedConfigButton.setBackground(new Color(255, 255, 255));
        this.currentConfigButton = new JRadioButton();
        this.currentConfigButton.setBackground(new Color(255, 255, 255));
        this.title = new JLabel("Configuration data for " + this.serialNo);
        this.title.setFont(new Font("Arial", 1, 16));
        this.title.setForeground(new Color(51, 0, 153));
        this.buttonGroup1 = new ButtonGroup();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.title, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        gridBagConstraints.weighty = 0.7;
        gridBagConstraints.fill = 1;
        this.add((Component)this.scrollPane, gridBagConstraints);
        this.saveConfigButton.setFont(new Font("Arial", 0, 12));
        this.saveConfigButton.setText("Save this Configuration");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.saveConfigButton, gridBagConstraints);
        this.saveConfigButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ModuleConfigurationPanel.this.updateConfiguration();
            }
        });
        this.storedConfigButton.setFont(new Font("Arial", 0, 12));
        this.storedConfigButton.setText("Stored Configuration");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.storedConfigButton, gridBagConstraints);
        this.currentConfigButton.setFont(new Font("Arial", 0, 12));
        this.currentConfigButton.setText("Current Configuration");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.currentConfigButton, gridBagConstraints);
        this.buttonGroup1.add(this.storedConfigButton);
        this.buttonGroup1.add(this.currentConfigButton);
        this.storedConfigButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ModuleConfigurationPanel.this.getSavedModuleConfig();
                if (ModuleConfigurationPanel.this.savedIP != null) {
                    ModuleConfigurationPanel.this.scrollPane.setViewportView(((ModuleConfigurationPanel)ModuleConfigurationPanel.this).savedIP.treeTable);
                } else {
                    ModuleConfigurationPanel.this.scrollPane.setViewportView(ModuleConfigurationPanel.this.defaultText);
                }
            }
        });
        this.currentConfigButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ModuleConfigurationPanel.this.getCurrentModuleConfig();
                if (ModuleConfigurationPanel.this.currentIP != null) {
                    ModuleConfigurationPanel.this.scrollPane.setViewportView(((ModuleConfigurationPanel)ModuleConfigurationPanel.this).currentIP.treeTable);
                } else {
                    ModuleConfigurationPanel.this.scrollPane.setViewportView(ModuleConfigurationPanel.this.defaultText);
                }
            }
        });
        this.storedConfigButton.setSelected(true);
        this.getSavedModuleConfig();
        if (this.savedIP != null) {
            this.scrollPane.setViewportView(this.savedIP.treeTable);
        } else {
            this.scrollPane.setViewportView(this.defaultText);
        }
    }
}

