/*
 * Decompiled with CFR 0.152.
 */
package TestGUI;

import GuiComponents.Console.ExternalProcess;
import GuiComponents.Inspector.InspectorPanel;
import GuiComponents.System.ISInterface;
import GuiComponents.System.SystemInterface;
import GuiComponents.plotter.PlotterManager;
import Sct.IS.AnyInfoAdapter;
import Sct.IS.NameIS;
import Sct.IS.ObjectManagerIS;
import Sct.IS.SctNames;
import Sct.Serializable;
import is.AnyInfo;
import is.Info;
import is.InfoEvent;
import is.InfoList;
import is.InfoListener;
import is.ServerIterator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.EtchedBorder;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ISPanel
extends JPanel
implements InfoListener {
    private JButton bDelete;
    private JButton bDeleteAll;
    private JButton bExternal;
    private JButton bISData;
    private JButton bISRefresh;
    private JButton bInternal;
    private JButton bIsdump;
    private JLabel jLabel2;
    private JPanel jPanel2;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JLabel lList;
    private JTree trISServers;
    private SystemInterface si;
    private ISInterface is;
    private JTextArea taMessages;
    private PlotterManager plotterManager;

    public ISPanel(JTextArea jTextArea) {
        this.taMessages = jTextArea;
        this.si = SystemInterface.getInstance();
        this.is = ISInterface.getInstance();
        this.initComponents();
        this.myInitComponents();
    }

    void close() {
        this.unsubscribeAll();
    }

    private void myInitComponents() {
        this.refreshISTree(false);
    }

    private void initComponents() {
        this.lList = new JLabel();
        this.bDelete = new JButton();
        this.bISRefresh = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jPanel2 = new JPanel();
        this.trISServers = new JTree();
        this.trISServers.getPreferredScrollableViewportSize();
        this.jSeparator1 = new JSeparator();
        this.bISData = new JButton();
        this.bExternal = new JButton();
        this.jLabel2 = new JLabel();
        this.bInternal = new JButton();
        this.bDeleteAll = new JButton();
        this.bIsdump = new JButton();
        this.setLayout(new GridBagLayout());
        this.lList.setText("List of available IS servers and objects");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lList, gridBagConstraints);
        this.bDelete.setText("Delete");
        this.bDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ISPanel.this.bDeleteActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.bDelete, gridBagConstraints);
        this.bISRefresh.setText("Refresh");
        this.bISRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ISPanel.this.bISRefreshActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.bISRefresh, gridBagConstraints);
        this.jScrollPane2.setMinimumSize(new Dimension(200, 100));
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 1));
        this.jPanel2.setMinimumSize(new Dimension(200, 200));
        this.trISServers.setBorder(new EtchedBorder());
        this.trISServers.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.trISServers.setAutoscrolls(true);
        this.trISServers.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                ISPanel.this.trISServersKeyReleased(keyEvent);
            }
        });
        this.trISServers.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ISPanel.this.trISServersMouseClicked(mouseEvent);
            }
        });
        this.jPanel2.add(this.trISServers);
        this.jScrollPane2.setViewportView(this.jPanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 12;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.bISData.setText("IS Data");
        this.bISData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ISPanel.this.bISDataActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.bISData, gridBagConstraints);
        this.bExternal.setText("External Graphics");
        this.bExternal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ISPanel.this.bExternalActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.bExternal, gridBagConstraints);
        this.jLabel2.setText("View...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.bInternal.setText("Internal Graphics");
        this.bInternal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ISPanel.this.bInternalActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.bInternal, gridBagConstraints);
        this.bDeleteAll.setText("Delete All");
        this.bDeleteAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ISPanel.this.bDeleteAllActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.bDeleteAll, gridBagConstraints);
        this.bIsdump.setText("IS Dump");
        this.bIsdump.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ISPanel.this.bIsdumpActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.bIsdump, gridBagConstraints);
    }

    private void bIsdumpActionPerformed(ActionEvent actionEvent) {
        TreePath[] treePathArray = this.trISServers.getSelectionPaths();
        int n = 0;
        while (n < treePathArray.length) {
            this.dumpISData(treePathArray[n].getLastPathComponent().toString());
            ++n;
        }
    }

    private void bDeleteAllActionPerformed(ActionEvent actionEvent) {
        ServerIterator serverIterator = new ServerIterator(this.si.getPartition());
        while (serverIterator.hasMoreElements()) {
            InfoList infoList = new InfoList(this.si.getPartition(), serverIterator.nextServerName());
            int n = 0;
            while (n < infoList.size()) {
                this.is.remove(infoList.getInfo(n).getName());
                ++n;
            }
        }
    }

    private void bInternalActionPerformed(ActionEvent actionEvent) {
        TreePath[] treePathArray = this.trISServers.getSelectionPaths();
        int n = 0;
        while (n < treePathArray.length) {
            this.plotISData(treePathArray[n].getLastPathComponent().toString());
            ++n;
        }
    }

    private void bExternalActionPerformed(ActionEvent actionEvent) {
        TreePath[] treePathArray = this.trISServers.getSelectionPaths();
        int n = 0;
        while (n < treePathArray.length) {
            this.launchExternalViewer(treePathArray[n].getLastPathComponent().toString());
            ++n;
        }
    }

    private void bISDataActionPerformed(ActionEvent actionEvent) {
        TreePath[] treePathArray = this.trISServers.getSelectionPaths();
        int n = 0;
        while (n < treePathArray.length) {
            this.viewISData(treePathArray[n].getLastPathComponent().toString());
            ++n;
        }
    }

    private void trISServersKeyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 127: {
                this.deleteSelectedInfos();
                break;
            }
        }
    }

    private void trISServersMouseClicked(MouseEvent mouseEvent) {
        int n = this.trISServers.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        TreePath treePath = this.trISServers.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (n != -1 && mouseEvent.getClickCount() == 2) {
            String string = treePath.getLastPathComponent().toString();
            this.viewISData(string);
        }
    }

    private void bCreateTrimRangeTestActionPerformed(ActionEvent actionEvent) {
    }

    private void bISRefreshActionPerformed(ActionEvent actionEvent) {
        this.refreshISTree(true);
    }

    private void bDeleteActionPerformed(ActionEvent actionEvent) {
        this.deleteSelectedInfos();
    }

    private void plotISData(String string) {
        if (this.plotterManager == null) {
            this.initPlotterManager();
        }
        try {
            Serializable serializable = ObjectManagerIS.getInstance().readObject(string);
            this.plotterManager.plot(serializable);
        }
        catch (IOException iOException) {
            this.taMessages.append("Error reading object from IS: " + iOException + "  " + iOException.getMessage() + "\n");
        }
        this.taMessages.append("IS Object: " + string + " plotted\n");
    }

    private void initPlotterManager() {
        this.plotterManager = PlotterManager.defaultManager();
        JFrame jFrame = new JFrame("Plots");
        jFrame.getContentPane().add(this.plotterManager.getPlotPanel());
        jFrame.pack();
        jFrame.show();
    }

    private void viewISData(String string) {
        try {
            Serializable serializable = ObjectManagerIS.getInstance().readObject(string);
            InspectorPanel inspectorPanel = new InspectorPanel(string, serializable);
            JFrame jFrame = new JFrame("TreeTable");
            jFrame.getContentPane().add(new JScrollPane(inspectorPanel.treeTable));
            jFrame.pack();
            jFrame.show();
        }
        catch (IOException iOException) {
            this.taMessages.append("Error reading object from IS: " + iOException + "  " + iOException.getMessage() + "\n");
        }
        this.taMessages.append("IS Object: " + string + " viewed\n");
    }

    private void dumpISData(String string) {
        try {
            AnyInfo anyInfo = new AnyInfo();
            this.is.getRepository().getValue(string, (Info)anyInfo);
            InspectorPanel inspectorPanel = new InspectorPanel(string, (Serializable)new AnyInfoAdapter(anyInfo));
            JFrame jFrame = new JFrame("TreeTable");
            jFrame.getContentPane().add(new JScrollPane(inspectorPanel.treeTable));
            jFrame.pack();
            jFrame.show();
        }
        catch (Exception exception) {
            this.taMessages.append("Error reading object from IS: " + exception + "  " + exception.getMessage() + "\n");
        }
        this.taMessages.append("IS Object: " + string + " dumped\n");
    }

    private void launchExternalViewer(String string) {
        try {
            NameIS nameIS = new NameIS(string);
            String string2 = nameIS.getISServer();
            if (string2.equals(SctNames.getEventISServer())) {
                this.launchExternalRaw(string);
                return;
            }
            if (string2.equals(SctNames.getFitISServer())) {
                this.launchExternalFit(string);
                return;
            }
            if (string.indexOf("NPtGainTestResult") != -1) {
                this.launchExternalNPtGain(string);
                return;
            }
            if (string.indexOf("TrimRangeTestResult") != -1) {
                this.launchExternalTrimRange(string);
                return;
            }
            if (string.indexOf("StrobeDelayTestResult") != -1) {
                this.launchExternalStrobeDelay(string);
                return;
            }
            if (string.indexOf("NoiseOccupancyTestResult") != -1) {
                this.launchExternalNoiseOccupancy(string);
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        System.out.println("Couldn't launch external viewer for: " + string);
    }

    private void launchExternalRaw(String string) {
        try {
            ExternalProcess externalProcess = new ExternalProcess("TestRetrieve " + string);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void launchExternalFit(String string) {
        try {
            ExternalProcess externalProcess = new ExternalProcess("TestRetrieveFit " + string + " 0 36");
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void launchExternalNPtGain(String string) {
        try {
            ExternalProcess externalProcess = new ExternalProcess("TestNPtGain " + string);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void launchExternalStrobeDelay(String string) {
        try {
            ExternalProcess externalProcess = new ExternalProcess("TestStrobeDelay " + string);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void launchExternalTrimRange(String string) {
        try {
            ExternalProcess externalProcess = new ExternalProcess("TestTrimRange " + string);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void launchExternalNoiseOccupancy(String string) {
        try {
            ExternalProcess externalProcess = new ExternalProcess("TestNO " + string);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    protected void refreshISTree(boolean bl) {
        if (bl) {
            this.unsubscribeAll();
        }
        String[] stringArray = this.is.getISServers();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("IS Servers");
        int n = 0;
        while (n < stringArray.length) {
            this.is.subscribe(stringArray[n], this);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(stringArray[n]);
            String[] stringArray2 = this.is.getISObjects(stringArray[n]);
            int n2 = 0;
            while (n2 < stringArray2.length) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(stringArray2[n2]);
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                ++n2;
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            ++n;
        }
        this.trISServers.setModel(new DefaultTreeModel(defaultMutableTreeNode));
    }

    protected void unsubscribeAll() {
        TreeModel treeModel = this.trISServers.getModel();
        Object object = treeModel.getRoot();
        int n = 0;
        while (n < treeModel.getChildCount(object)) {
            this.is.unsubscribe(treeModel.getChild(object, n).toString());
            ++n;
        }
    }

    private void deleteSelectedInfos() {
        TreePath[] treePathArray = this.trISServers.getSelectionPaths();
        int n = 0;
        while (n < treePathArray.length) {
            String string = treePathArray[n].getLastPathComponent().toString();
            this.taMessages.append(this.is.remove(string) + "\n");
            ++n;
        }
    }

    public void infoCreated(InfoEvent infoEvent) {
        String string = infoEvent.getName().split("\\.")[0];
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        int n = 0;
        while (n < this.trISServers.getModel().getChildCount(this.trISServers.getModel().getRoot())) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.trISServers.getModel().getChild(this.trISServers.getModel().getRoot(), n);
            if (defaultMutableTreeNode.toString().equals(string)) {
                String string2 = new String(infoEvent.getName());
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string2);
                ((DefaultTreeModel)this.trISServers.getModel()).insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                return;
            }
            ++n;
        }
        System.err.println("Server: " + string + " not found");
    }

    public void infoDeleted(InfoEvent infoEvent) {
        TreePath treePath = this.trISServers.getNextMatch(new String(infoEvent.getName()), 0, Position.Bias.Forward);
        if (treePath == null) {
            System.out.println(infoEvent.getName() + " not found in tree");
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        ((DefaultTreeModel)this.trISServers.getModel()).removeNodeFromParent(defaultMutableTreeNode);
    }

    public void infoUpdated(InfoEvent infoEvent) {
        this.taMessages.append(new String(infoEvent.getName()) + " has been updated\n");
    }
}

