/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.JASIcon;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class SpinBox
extends JComponent {
    private int max = 100;
    private int min = 0;
    private int value = 0;
    private int delay = 50;
    private boolean valueChanging = false;
    private JTextField field;
    private JButton plus = new JButton(JASIcon.create(this, "up.gif"));
    private JButton minus = new JButton(JASIcon.create(this, "down.gif"));
    private Vector listener = new Vector();

    public SpinBox(int n, int n2, int n3) {
        if (n2 < 0 || n3 < n2 || n < n2 || n > n3) {
            throw new IllegalArgumentException("Invalid initial parameters for spin box");
        }
        this.value = n;
        this.min = n2;
        this.max = n3;
        this.valueChanging = true;
        this.field = new JTextField(new SpinDocument(), String.valueOf(n), (int)(1.0 + Math.log(Math.abs(n3)) / Math.log(10.0)));
        this.valueChanging = false;
        this.valueChanged();
        this.plus.setMargin(new Insets(0, 0, 0, 0));
        this.plus.setModel(new MachineGunButtonModel());
        this.minus.setMargin(new Insets(0, 0, 0, 0));
        this.minus.setModel(new MachineGunButtonModel());
        this.setLayout(new FlowLayout(1, 0, 0));
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.add("North", this.plus);
        jPanel.add("South", this.minus);
        this.add(this.field);
        this.add(jPanel);
        this.plus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpinBox.this.value++;
                SpinBox.this.valueChanged();
            }
        });
        this.minus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpinBox.this.value--;
                SpinBox.this.valueChanged();
            }
        });
    }

    public void addActionListener(ActionListener actionListener) {
        this.listener.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listener.removeElement(actionListener);
    }

    private void fireActionListener() {
        ActionEvent actionEvent = new ActionEvent(this, 1001, "hi");
        Enumeration enumeration = this.listener.elements();
        while (enumeration.hasMoreElements()) {
            ((ActionListener)enumeration.nextElement()).actionPerformed(actionEvent);
        }
    }

    private void valueChanged() {
        if (this.value > this.max) {
            this.value = this.max;
        }
        if (this.value < this.min) {
            this.value = this.min;
        }
        this.plus.setEnabled(this.value < this.max);
        this.minus.setEnabled(this.value > this.min);
        if (!this.valueChanging) {
            this.valueChanging = true;
            this.field.setText(String.valueOf(this.value));
            this.valueChanging = false;
        }
        this.fireActionListener();
    }

    public void setMin(int n) {
        this.min = n;
    }

    public void setMax(int n) {
        this.max = n;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
        this.valueChanged();
    }

    public int getRepeatDelay() {
        return this.delay;
    }

    public void setRepeatDelay(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid repeatDelay set");
        }
        this.delay = n;
    }

    public void setEnabled(boolean bl) {
        this.plus.setEnabled(bl);
        this.minus.setEnabled(bl);
        this.field.setEnabled(bl);
        super.setEnabled(bl);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setContentPane(new SpinBox(50, 1, 999));
        jFrame.pack();
        jFrame.show();
    }

    private class SpinDocument
    extends PlainDocument
    implements Runnable {
        private SpinDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            int n2;
            if (!SpinBox.this.valueChanging) {
                n2 = 0;
                while (n2 < string.length()) {
                    if (!Character.isDigit(string.charAt(n2))) {
                        SpinBox.this.getToolkit().beep();
                        return;
                    }
                    ++n2;
                }
            }
            super.insertString(n, string, attributeSet);
            if (!SpinBox.this.valueChanging) {
                n2 = Integer.parseInt(SpinBox.this.field.getText());
                if (n2 < SpinBox.this.min || n2 > SpinBox.this.max) {
                    super.remove(n, string.length());
                    SpinBox.this.getToolkit().beep();
                    return;
                }
                SpinBox.this.value = n2;
                SpinBox.this.valueChanging = true;
                SpinBox.this.valueChanged();
                SpinBox.this.valueChanging = false;
            }
        }

        public void remove(int n, int n2) throws BadLocationException {
            super.remove(n, n2);
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            if (SpinBox.this.field == null) {
                return;
            }
            String string = SpinBox.this.field.getText();
            int n = string.length() == 0 ? Integer.MIN_VALUE : Integer.parseInt(SpinBox.this.field.getText());
            if (n < SpinBox.this.min) {
                n = SpinBox.this.min;
                SpinBox.this.getToolkit().beep();
                SpinBox.this.field.setText(String.valueOf(n));
            }
            SpinBox.this.value = n;
            SpinBox.this.valueChanging = true;
            SpinBox.this.valueChanged();
            SpinBox.this.valueChanging = false;
        }
    }

    private class MachineGunButtonModel
    extends DefaultButtonModel
    implements ActionListener {
        private Timer timer;

        private MachineGunButtonModel() {
        }

        public void setPressed(boolean bl) {
            if (!bl && this.timer != null && this.timer.isRunning()) {
                this.timer.stop();
            }
            if (this.isPressed() == bl || !this.isEnabled()) {
                return;
            }
            this.stateMask = bl ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            if (this.isPressed() && this.isArmed()) {
                this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
            }
            if (this.timer == null && this.isPressed() && SpinBox.this.delay > 0) {
                this.timer = new Timer(SpinBox.this.delay, this);
                this.timer.setInitialDelay(500);
            }
            if (this.isPressed()) {
                this.timer.start();
            }
            this.fireStateChanged();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isEnabled() && this.isArmed() && this.isPressed()) {
                this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
            }
        }
    }
}

