/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.FilePreview;
import jas.util.JASEditableComboBox;
import jas.util.UserProperties;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class OpenLocalFilePanel
extends JPanel
implements ActionListener,
ChangeListener {
    private String m_lastLocalDirectory_Key;
    private JASEditableComboBox m_fileName;
    private JButton m_browse;
    private JButton m_view = null;
    private JCheckBox m_gzip = null;
    private final UserProperties m_prop = UserProperties.getUserProperties();
    private FileFilter m_filter = null;

    public OpenLocalFilePanel(boolean bl, boolean bl2, String string, FileFilter fileFilter) {
        this(bl, bl2, string);
        this.m_filter = fileFilter;
    }

    public OpenLocalFilePanel(boolean bl, boolean bl2, String string) {
        this.m_lastLocalDirectory_Key = string + "-directory";
        this.m_fileName = new JASEditableComboBox(string + "-files", 4, true);
        this.m_fileName.addChangeListener(this);
        this.m_fileName.setMinWidth(250);
        this.m_fileName.setMaxWidth(250);
        this.add(this.m_fileName);
        this.m_browse = new JButton("Browse...");
        this.m_browse.addActionListener(this);
        this.m_browse.setMnemonic('B');
        this.add(this.m_browse);
        if (bl) {
            this.m_view = new JButton("Preview");
            this.m_view.addActionListener(this);
            this.m_view.setMnemonic('V');
            this.add(this.m_view);
            this.m_view.setEnabled(false);
        }
        if (bl2) {
            this.m_gzip = new JCheckBox("GZIPed");
            this.m_gzip.addActionListener(this);
            this.m_gzip.setMnemonic('Z');
            this.add(this.m_gzip);
            this.m_gzip.setEnabled(false);
        }
        this.setBorder(BorderFactory.createTitledBorder("Enter the data file name"));
        this.setViewEnabled();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.m_fileName.addChangeListener(changeListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.m_fileName.addActionListener(actionListener);
    }

    public final void stateChanged(ChangeEvent changeEvent) {
        this.setViewEnabled();
    }

    private void setViewEnabled() {
        boolean bl;
        String string = this.m_fileName.getText();
        boolean bl2 = bl = string.length() > 0;
        if (this.m_view != null) {
            this.m_view.setEnabled(bl);
        }
        if (this.m_gzip != null) {
            this.m_gzip.setEnabled(bl);
            this.m_gzip.setSelected(string.endsWith(".gz"));
        }
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        block5: {
            Object object;
            block4: {
                object = actionEvent.getSource();
                if (object != this.m_browse) break block4;
                JFileChooser jFileChooser = new JFileChooser(this.m_prop.getString(this.m_lastLocalDirectory_Key, System.getProperty("user.home")));
                jFileChooser.setDialogTitle("Select a file");
                if (this.m_filter != null) {
                    jFileChooser.setFileFilter(this.m_filter);
                }
                if (jFileChooser.showDialog(this, "Select") != 0) break block5;
                File file = jFileChooser.getSelectedFile();
                this.m_fileName.setText(file.getAbsolutePath());
                this.m_prop.setString(this.m_lastLocalDirectory_Key, file.getParent());
                break block5;
            }
            if (object != this.m_view) break block5;
            try {
                Container container = this;
                while (!(container instanceof Frame)) {
                    container = container.getParent();
                }
                new FilePreview((Frame)container, new File(this.m_fileName.getText()), this.m_gzip == null ? false : this.m_gzip.isSelected());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception instanceof FileNotFoundException ? "File not found" : "Could not read file", "Error...", 0);
            }
        }
    }

    public String getText() {
        String string = this.m_fileName.getText();
        return string;
    }

    public void saveState() {
        this.m_fileName.saveState();
    }

    public boolean getGZIPed() {
        return this.m_gzip == null ? false : this.m_gzip.isSelected();
    }
}

