/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.ChartLayout;
import jas.plot.DataArea;
import jas.plot.JASPlotMouseListener;
import jas.plot.MovableObject;
import jas.plot.PlotComponent;
import jas.plot.PopupMenuBuilder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;

public class PlotPanel
extends PlotComponent
implements ContainerListener,
MouseListener,
MouseMotionListener {
    private PopupMenuBuilder menuBuilder = new PopupMenuBuilder();
    private MovableObject componentWithHandles;
    private boolean allowUserInteraction = true;
    private boolean allowPopupMenus = true;
    static /* synthetic */ Class class$jas$plot$MovableObject;

    public PlotPanel() {
        super(new ChartLayout());
        this.enableEvents(2L);
        this.enableEvents(16L);
    }

    public Component add(Component component) {
        if (component instanceof DataArea) {
            return super.add(component);
        }
        return super.add(component, 0);
    }

    protected final void processContainerEvent(ContainerEvent containerEvent) {
        if (containerEvent.getID() == 300) {
            this.componentAdded(containerEvent);
        } else {
            this.componentRemoved(containerEvent);
        }
    }

    public void restoreDefaultLayout() {
        ChartLayout chartLayout = (ChartLayout)this.getLayout();
        chartLayout.restoreDefaultLayout();
        this.revalidate();
    }

    public boolean hasDefaultLayout() {
        ChartLayout chartLayout = (ChartLayout)this.getLayout();
        return chartLayout.hasDefaultLayout();
    }

    protected final void processMouseEvent(MouseEvent mouseEvent) {
        if (!this.allowUserInteraction) {
            return;
        }
        if (mouseEvent.getID() == 501 && this.componentWithHandles != null) {
            this.componentWithHandles.hideHandles();
            this.componentWithHandles = null;
        }
        if (this.allowPopupMenus) {
            this.menuBuilder.buildMenu(mouseEvent);
        }
    }

    private void propagateMouseMotionEvent(MouseEvent mouseEvent) {
        if (!this.allowUserInteraction) {
            return;
        }
        Component component = (Component)mouseEvent.getSource();
        if (this.componentWithHandles != null) {
            this.componentWithHandles.mouseMotionEventNotify(SwingUtilities.convertMouseEvent(component, mouseEvent, this.componentWithHandles));
        } else {
            Component component2 = component;
            while (component2 != null) {
                if (component2 instanceof MovableObject) {
                    ((MovableObject)component2).mouseMotionEventNotify(SwingUtilities.convertMouseEvent(component, mouseEvent, component2));
                }
                component2 = component2.getParent();
            }
        }
    }

    private void propagateMouseEvent(MouseEvent mouseEvent) {
        if (!this.allowUserInteraction) {
            return;
        }
        Component component = (Component)mouseEvent.getSource();
        if (this.componentWithHandles != null) {
            this.componentWithHandles.mouseEventNotify(SwingUtilities.convertMouseEvent(component, mouseEvent, this.componentWithHandles));
        }
        Component component2 = component;
        while (component2 != null) {
            if (component2 instanceof JASPlotMouseListener) {
                ((JASPlotMouseListener)((Object)component2)).mouseEventNotify(SwingUtilities.convertMouseEvent(component, mouseEvent, component2));
            }
            component2 = component2.getParent();
        }
        if (this.allowPopupMenus) {
            this.menuBuilder.buildMenu(mouseEvent);
        }
    }

    private void addComponent(Component component) {
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.addContainerListener(this);
            Component[] componentArray = container.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this.addComponent(componentArray[n]);
                ++n;
            }
        }
    }

    private void removeComponent(Component component) {
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.removeContainerListener(this);
            Component[] componentArray = container.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this.removeComponent(componentArray[n]);
                ++n;
            }
        }
    }

    public final void deselected() {
        if (this.componentWithHandles != null) {
            this.componentWithHandles.hideHandles();
            this.componentWithHandles = null;
        }
    }

    public final void componentAdded(ContainerEvent containerEvent) {
        this.addComponent(containerEvent.getChild());
    }

    public final void componentRemoved(ContainerEvent containerEvent) {
        this.removeComponent(containerEvent.getChild());
    }

    public final void mouseClicked(MouseEvent mouseEvent) {
        this.propagateMouseEvent(mouseEvent);
    }

    public final void mouseEntered(MouseEvent mouseEvent) {
        this.propagateMouseEvent(mouseEvent);
    }

    public final void mouseExited(MouseEvent mouseEvent) {
        this.propagateMouseEvent(mouseEvent);
    }

    public final void mousePressed(MouseEvent mouseEvent) {
        Point point;
        if (!this.allowUserInteraction) {
            return;
        }
        Object object = mouseEvent.getSource();
        MovableObject movableObject = null;
        if (this.componentWithHandles != null && object instanceof Component && this.componentWithHandles.contains(point = SwingUtilities.convertPoint((Component)object, mouseEvent.getX(), mouseEvent.getY(), this.componentWithHandles))) {
            this.propagateMouseEvent(mouseEvent);
            return;
        }
        movableObject = object instanceof MovableObject ? (MovableObject)object : (MovableObject)SwingUtilities.getAncestorOfClass(class$jas$plot$MovableObject == null ? (class$jas$plot$MovableObject = PlotPanel.class$("jas.plot.MovableObject")) : class$jas$plot$MovableObject, (Component)object);
        if (movableObject != null && movableObject != this.componentWithHandles) {
            if (this.componentWithHandles != null) {
                this.componentWithHandles.hideHandles();
            }
            this.componentWithHandles = movableObject;
            this.componentWithHandles.showHandles();
            this.requestFocus();
        }
        this.propagateMouseEvent(mouseEvent);
    }

    public final void processFocusEvent(FocusEvent focusEvent) {
        if (focusEvent.getID() == 1005) {
            this.deselected();
        }
        super.processFocusEvent(focusEvent);
    }

    public final void mouseReleased(MouseEvent mouseEvent) {
        this.propagateMouseEvent(mouseEvent);
    }

    public final void mouseDragged(MouseEvent mouseEvent) {
        this.propagateMouseMotionEvent(mouseEvent);
    }

    public final void mouseMoved(MouseEvent mouseEvent) {
        this.propagateMouseMotionEvent(mouseEvent);
    }

    public void setAllowUserInteraction(boolean bl) {
        this.allowUserInteraction = bl;
    }

    public boolean getAllowUserInteraction() {
        return this.allowUserInteraction;
    }

    public void setAllowPopupMenus(boolean bl) {
        this.allowPopupMenus = bl;
    }

    public boolean getAllowPopupMenus() {
        return this.allowPopupMenus;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

