/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataManagerException;
import jas.hist.DataSource;
import jas.hist.JASHist;
import jas.hist.JASHist1DHistogramData;
import jas.hist.JASHistData;
import jas.hist.OneDDataManager;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.StatisticsBlock;
import jas.plot.DataArea;
import jas.plot.DoubleAxis;
import jas.plot.Legend;
import jas.plot.StringAxis;
import java.util.Enumeration;
import java.util.Hashtable;

final class StringDataManager
extends OneDDataManager {
    private StringAxis xAxis = new StringAxis();
    private DoubleAxis yAxis = new DoubleAxis();

    StringDataManager(JASHist jASHist, DataArea dataArea, Legend legend, StatisticsBlock statisticsBlock) {
        super(jASHist, dataArea, legend, statisticsBlock);
        this.yAxis.setUseSuggestedRange(true);
        this.xm.setDataManager(this, true, this.xAxis);
        this.xm.setFixed(true);
        this.ym[0].setDataManager(this, false, this.yAxis);
    }

    JASHistData add(DataSource dataSource) {
        Rebinnable1DHistogramData rebinnable1DHistogramData = (Rebinnable1DHistogramData)dataSource;
        if (rebinnable1DHistogramData.getAxisType() != 2) {
            throw new DataManagerException("Data incompatible with String axis");
        }
        JASHist1DHistogramData jASHist1DHistogramData = new JASHist1DHistogramData(this, rebinnable1DHistogramData);
        this.data.addElement(jASHist1DHistogramData);
        return jASHist1DHistogramData;
    }

    void destroy() {
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            JASHistData jASHistData = (JASHistData)enumeration.nextElement();
            jASHistData.destroy();
            jASHistData.show(false);
        }
        this.data.removeAllElements();
    }

    void XAxisUpdated() {
    }

    void computeXAxisRange() {
        int n;
        Object object;
        String[] stringArray;
        if (this.data.isEmpty()) {
            return;
        }
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        Object object2 = null;
        int n2 = 0;
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            if (!stringArray.isShowing()) continue;
            object = stringArray.getAxisLabels();
            if (n2++ == 0) {
                object2 = object;
            }
            n = 0;
            while (n < ((Object)object).length) {
                hashtable.put(object[n], object[n]);
                ++n;
            }
        }
        if (n2 == 0) {
            return;
        }
        if (n2 > 1) {
            stringArray = new String[hashtable.size()];
            object = hashtable.keys();
            n = 0;
            while (object.hasMoreElements()) {
                stringArray[n] = (String)object.nextElement();
                ++n;
            }
            this.xAxis.setLabels(stringArray);
        } else {
            this.xAxis.setLabels((String[])object2);
        }
        this.xAxis.getAxis().invalidate();
    }

    void computeYAxisRange() {
        if (this.data.isEmpty()) {
            return;
        }
        if (!this.ym[0].getRangeAutomatic()) {
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = true;
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            JASHist1DHistogramData jASHist1DHistogramData = (JASHist1DHistogramData)enumeration.nextElement();
            if (!jASHist1DHistogramData.isShowing()) continue;
            if (bl) {
                d = jASHist1DHistogramData.getYMin();
                d2 = jASHist1DHistogramData.getYMax();
                bl = false;
                continue;
            }
            d = Math.min(d, jASHist1DHistogramData.getYMin());
            d2 = Math.max(d2, jASHist1DHistogramData.getYMax());
        }
        if (d2 <= d) {
            d2 = d + 1.0;
        }
        if (this.yAxis.isLogarithmic()) {
            d = Math.max(d, 1.0);
        }
        double d3 = this.yAxis.getPlotMin();
        double d4 = this.yAxis.getPlotMax();
        if (d < d3 || d2 > d4 || (d2 - d) / (d4 - d3) < 0.75) {
            this.yAxis.setMin(d);
            this.yAxis.setMax(d2);
            this.yAxis.getAxis().revalidate();
        }
    }
}

