/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.AbstractDataManager;
import jas.hist.DataSource;
import jas.hist.DataSourceMenuFactory;
import jas.hist.HasSlices;
import jas.hist.JASHist;
import jas.hist.JASHistData;
import jas.hist.ManagedAxis;
import jas.hist.SliceOverlay;
import jas.hist.SliceParameters;
import jas.hist.StatisticsBlock;
import jas.hist.SupportsSlices;
import jas.plot.DataArea;
import jas.plot.Legend;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

abstract class SliceableDataManager
extends AbstractDataManager
implements SupportsSlices {
    private Vector slices = new Vector();

    SliceableDataManager(JASHist jASHist, DataArea dataArea, Legend legend, StatisticsBlock statisticsBlock) {
        super(jASHist, dataArea, legend, statisticsBlock);
    }

    public void addSlice(SliceParameters sliceParameters) {
        SliceOverlay sliceOverlay = new SliceOverlay(sliceParameters);
        this.slices.addElement(sliceOverlay);
        this.da.add(sliceOverlay);
    }

    public void removeAllSlices() {
        Enumeration enumeration = this.slices.elements();
        while (enumeration.hasMoreElements()) {
            SliceOverlay sliceOverlay = (SliceOverlay)enumeration.nextElement();
            this.da.remove(sliceOverlay);
        }
        this.slices.removeAllElements();
    }

    void destroy() {
        super.destroy();
        this.removeAllSlices();
        this.slices.removeAllElements();
    }

    public void fillSliceMenu(JMenu jMenu) {
        jMenu.add(this.addPerDataSourceMenu("Add Slice/Projection", new DataSourceMenuFactory(){

            public JMenu createMenu(String string, JASHistData jASHistData) {
                return new SliceMenu(string, jASHistData);
            }
        }));
        jMenu.add(this.addPerDataSourceMenu("Remove Slice/Projection", new DataSourceMenuFactory(){

            public JMenu createMenu(String string, JASHistData jASHistData) {
                return new RemoveSliceMenu(string, jASHistData);
            }
        }));
    }

    void modifyPopupMenu(JPopupMenu jPopupMenu, Component component) {
        jPopupMenu.add(this.addPerDataSourceMenu("Add Slice/Projection", new DataSourceMenuFactory(){

            public JMenu createMenu(String string, JASHistData jASHistData) {
                return new SliceMenu(string, jASHistData);
            }
        }));
        jPopupMenu.add(this.addPerDataSourceMenu("Remove Slice/Projection", new DataSourceMenuFactory(){

            public JMenu createMenu(String string, JASHistData jASHistData) {
                return new RemoveSliceMenu(string, jASHistData);
            }
        }));
    }

    private final class RemoveSliceMenu
    extends JMenu {
        private HasSlices hasSlices;

        public RemoveSliceMenu(String string, JASHistData jASHistData) {
            super(string);
            DataSource dataSource = jASHistData.getDataSource();
            boolean bl = dataSource instanceof HasSlices && ((HasSlices)((Object)dataSource)).canAddRemoveSlices() && ((HasSlices)((Object)dataSource)).getNSlices() > 0;
            this.setEnabled(bl);
            if (bl) {
                this.hasSlices = (HasSlices)((Object)dataSource);
                this.add(new JMenuItem(this, "Remove All"){
                    private final /* synthetic */ RemoveSliceMenu this$1;
                    {
                        this.this$1 = removeSliceMenu;
                    }

                    public void fireActionPerformed(ActionEvent actionEvent) {
                        RemoveSliceMenu.access$200(this.this$1).removeAllSlices();
                        int n = RemoveSliceMenu.access$300(this.this$1).getNSlices();
                        while (n > 0) {
                            RemoveSliceMenu.access$300(this.this$1).removeSlice(--n);
                        }
                    }
                });
            }
        }

        static /* synthetic */ SliceableDataManager access$200(RemoveSliceMenu removeSliceMenu) {
            return removeSliceMenu.SliceableDataManager.this;
        }

        private class SliceItem
        extends JMenuItem {
            private int index;

            SliceItem(String string, int n) {
                super(string);
                this.index = n;
            }

            public void fireActionPerformed(ActionEvent actionEvent) {
                RemoveSliceMenu.this.hasSlices.removeSlice(this.index);
            }
        }
    }

    private final class SliceMenu
    extends JMenu {
        private HasSlices hasSlices;

        public SliceMenu(String string, JASHistData jASHistData) {
            super(string);
            DataSource dataSource = jASHistData.getDataSource();
            boolean bl = dataSource instanceof HasSlices && ((HasSlices)((Object)dataSource)).canAddRemoveSlices();
            this.setEnabled(bl);
            if (bl) {
                this.hasSlices = (HasSlices)((Object)dataSource);
                this.add(new SliceItem("X Projection", 0.0));
                this.add(new SliceItem("Y Projection", 1.5707963267948966));
                this.add(new SliceItem("X Slice", SliceableDataManager.this.xm, SliceableDataManager.this.ym[0], 0.0));
                this.add(new SliceItem("Y Slice", SliceableDataManager.this.xm, SliceableDataManager.this.ym[0], 1.5707963267948966));
            }
        }

        private class SliceItem
        extends JMenuItem {
            private double phi;
            private double x;
            private double y;
            private double width;
            private double height;

            SliceItem(String string, double d) {
                super(string);
                this.phi = d;
                this.x = 0.0;
                this.y = 0.0;
                this.width = Double.POSITIVE_INFINITY;
                this.height = Double.POSITIVE_INFINITY;
            }

            SliceItem(String string, ManagedAxis managedAxis, ManagedAxis managedAxis2, double d) {
                super(string);
                this.phi = d;
                this.x = (managedAxis.getMin() + managedAxis.getMax()) / 2.0;
                this.y = (managedAxis2.getMin() + managedAxis2.getMax()) / 2.0;
                if (d == 0.0) {
                    this.width = (managedAxis.getMax() - managedAxis.getMin()) / 4.0;
                    this.height = (managedAxis2.getMax() - managedAxis2.getMin()) / 4.0;
                } else {
                    this.height = (managedAxis.getMax() - managedAxis.getMin()) / 4.0;
                    this.width = (managedAxis2.getMax() - managedAxis2.getMin()) / 4.0;
                }
            }

            public void fireActionPerformed(ActionEvent actionEvent) {
                int n = SliceMenu.this.hasSlices.addSlice(this.x, this.y, this.width, this.height, this.phi);
                SliceableDataManager.this.addSlice(SliceMenu.this.hasSlices.getSliceParameters(n));
            }
        }
    }
}

