/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataSource;
import jas.hist.HistogramUpdate;
import jas.hist.JASHist;
import jas.hist.JASHist1DHistogramData;
import jas.hist.JASHistData;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.SliceableDataManager;
import jas.hist.StatisticsBlock;
import jas.plot.DataArea;
import jas.plot.Legend;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

abstract class OneDDataManager
extends SliceableDataManager {
    protected transient double xLow;
    protected transient double xHigh;
    static /* synthetic */ Class class$jas$hist$JASHist1DHistogramStyle;

    OneDDataManager(JASHist jASHist, DataArea dataArea, Legend legend, StatisticsBlock statisticsBlock) {
        super(jASHist, dataArea, legend, statisticsBlock);
    }

    JASHistData add(DataSource dataSource) {
        JASHist1DHistogramData jASHist1DHistogramData = new JASHist1DHistogramData(this, dataSource);
        this.data.addElement(jASHist1DHistogramData);
        return jASHist1DHistogramData;
    }

    void modifyPopupMenu(JPopupMenu jPopupMenu, Component component) {
        HistMenuItem histMenuItem = new HistMenuItem("Show Histogram Bars", "ShowHistogramBars");
        HistMenuItem histMenuItem2 = new HistMenuItem("Fill Histogram Bars", "HistogramFill");
        HistMenuItem histMenuItem3 = new HistMenuItem("Show Error Bars", "ShowErrorBars");
        HistMenuItem histMenuItem4 = new HistMenuItem("Draw Lines Between Points", "ShowLinesBetweenPoints");
        HistMenuItem histMenuItem5 = new HistMenuItem("Show Data Points", "ShowDataPoints");
        if (jPopupMenu.getComponentCount() > 0) {
            jPopupMenu.addSeparator();
        }
        jPopupMenu.add(histMenuItem);
        jPopupMenu.add(histMenuItem2);
        jPopupMenu.add(histMenuItem3);
        jPopupMenu.add(histMenuItem4);
        jPopupMenu.add(histMenuItem5);
        if (histMenuItem2.isEnabled()) {
            histMenuItem2.setEnabled(histMenuItem.isSelected());
        }
    }

    protected final void doUpdate() {
        if (this.isInit) {
            if (this.xm.needsAttention()) {
                this.computeXAxisRange();
                this.XAxisUpdated();
            }
            this.computeYAxisRange();
            this.stats.repaint();
            this.da.repaint();
        }
    }

    public void update(HistogramUpdate histogramUpdate, JASHistData jASHistData) {
        int n = jASHistData.getYAxis();
        if (histogramUpdate.isRangeUpdate() || histogramUpdate.isReset()) {
            this.xm.setAttentionNeeded();
        } else {
            this.ym[n].setAttentionNeeded();
        }
        if (histogramUpdate.isFinalUpdate() || histogramUpdate.isReset()) {
            SwingUtilities.invokeLater(this);
            if (histogramUpdate.isReset()) {
                boolean bl = ((Rebinnable1DHistogramData)jASHistData.getDataSource()).isRebinnable();
                this.xm.setFixed(!bl);
                this.xm.setRangeAutomatic(bl);
            }
        } else {
            this.timer.start();
        }
    }

    final void axisChanged(JASHistData jASHistData) {
        int n = jASHistData.getYAxis();
        if (this.ym[n] == null) {
            this.createYAxis(n);
        } else {
            this.ym[n].setAttentionNeeded();
        }
        SwingUtilities.invokeLater(this);
    }

    final void styleUpdate(JASHistData jASHistData) {
        int n = jASHistData.getYAxis();
        if (this.ym[n] == null) {
            this.createYAxis(n);
        } else {
            this.ym[n].setAttentionNeeded();
        }
        SwingUtilities.invokeLater(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class HistMenuItem
    extends JCheckBoxMenuItem {
        private String m_methodRoot;

        HistMenuItem(String string, String string2) {
            super(string);
            if (OneDDataManager.this.numberOfDataSources() > 0) {
                try {
                    this.m_methodRoot = string2;
                    Method method = (class$jas$hist$JASHist1DHistogramStyle == null ? (class$jas$hist$JASHist1DHistogramStyle = OneDDataManager.class$("jas.hist.JASHist1DHistogramStyle")) : class$jas$hist$JASHist1DHistogramStyle).getMethod("get".concat(string2), new Class[0]);
                    boolean bl = true;
                    Enumeration enumeration = OneDDataManager.this.getDataSources();
                    Object[] objectArray = new Object[]{};
                    while (bl && enumeration.hasMoreElements()) {
                        bl = (Boolean)method.invoke((Object)((JASHistData)enumeration.nextElement()).getStyle(), objectArray);
                    }
                    this.setSelected(bl);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.setEnabled(false);
                    this.setSelected(false);
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.setEnabled(false);
                    this.setSelected(false);
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.setEnabled(false);
                    this.setSelected(false);
                }
            } else {
                this.setEnabled(false);
                this.setSelected(false);
            }
        }

        protected void fireActionPerformed(ActionEvent actionEvent) {
            Class[] classArray = new Class[]{Boolean.TYPE};
            try {
                Method method = (class$jas$hist$JASHist1DHistogramStyle == null ? (class$jas$hist$JASHist1DHistogramStyle = OneDDataManager.class$("jas.hist.JASHist1DHistogramStyle")) : class$jas$hist$JASHist1DHistogramStyle).getMethod("set".concat(this.m_methodRoot), classArray);
                Object[] objectArray = new Object[]{new Boolean(this.isSelected())};
                Enumeration enumeration = OneDDataManager.this.getDataSources();
                while (enumeration.hasMoreElements()) {
                    try {
                        method.invoke((Object)((JASHistData)enumeration.nextElement()).getStyle(), objectArray);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {}
        }
    }
}

