/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataManager;
import jas.hist.DataSource;
import jas.hist.HasDataSource;
import jas.hist.HasStyle;
import jas.hist.HistogramUpdate;
import jas.hist.JASHist2DHistogramStyle;
import jas.hist.JASHistData;
import jas.hist.JASHistStyle;
import jas.hist.Rebinnable2DHistogramData;
import jas.hist.TwoDOverlay;
import jas.hist.XMLPrintWriter;
import jas.plot.Overlay;
import jas.util.ColorConverter;
import jas.util.xml.HasXMLRepresentation;
import java.util.Observable;

class JASHist2DHistogramData
extends JASHistData {
    protected Rebinnable2DHistogramData dataSource;
    protected JASHist2DHistogramStyle style;
    protected boolean hurry;
    protected boolean dataValid;
    boolean isBinned = false;
    private boolean zLimitsValid = false;
    private double[][] data;
    private int xBins;
    private double xLow;
    private double xHigh;
    private int yBins;
    private double yLow;
    private double yHigh;
    private double zMin;
    private double zMax;

    JASHist2DHistogramData(DataManager dataManager, Rebinnable2DHistogramData rebinnable2DHistogramData) {
        super(dataManager);
        this.dataSource = rebinnable2DHistogramData;
        this.initTransientData();
        JASHistStyle jASHistStyle = null;
        if (rebinnable2DHistogramData instanceof HasStyle) {
            jASHistStyle = ((HasStyle)((Object)rebinnable2DHistogramData)).getStyle();
        }
        if (jASHistStyle == null) {
            jASHistStyle = this.createStyle();
        }
        this.setStyle(jASHistStyle);
        String string = System.getProperty("hurry", "false");
        this.hurry = string != null && string.equalsIgnoreCase("true");
    }

    JASHistStyle createStyle() {
        return new JASHist2DHistogramStyle();
    }

    private void initTransientData() {
        this.zLimitsValid = false;
        this.isBinned = false;
    }

    public void setStyle(JASHistStyle jASHistStyle) {
        if (!(jASHistStyle instanceof JASHist2DHistogramStyle)) {
            throw new IllegalArgumentException("Style is not subclass of JASHist2DHistogramStyle");
        }
        if (this.style != null) {
            this.style.deleteObserver(this);
        }
        this.style = (JASHist2DHistogramStyle)jASHistStyle;
        this.style.addObserver(this);
    }

    public String getTitle() {
        return this.dataSource.getTitle();
    }

    Overlay createOverlay() {
        return new TwoDOverlay(this);
    }

    void writeAsXML(XMLPrintWriter xMLPrintWriter, boolean bl) {
        Object object;
        String string = XMLPrintWriter.convertAxisTypeToString(this.dataSource.getXAxisType());
        String string2 = XMLPrintWriter.convertAxisTypeToString(this.dataSource.getYAxisType());
        xMLPrintWriter.setAttribute("type", "histogram2d");
        xMLPrintWriter.openTag("data2d");
        if (bl) {
            boolean bl2;
            object = this.dataSource.rebin(this.xBins, this.xLow, this.xHigh, this.yBins, this.yLow, this.yHigh, true, this.hurry, this.style.getShowOverflow());
            if (object == null) {
                object = new double[1][this.xBins][this.yBins];
            }
            Object object2 = object[0];
            xMLPrintWriter.setAttribute("title", this.getTitle());
            xMLPrintWriter.setAttribute("xSize", ((Object)object2).length);
            xMLPrintWriter.setAttribute("ySize", ((Object)object2[0]).length);
            xMLPrintWriter.openTag("bins2d");
            Object object3 = new double[0][0];
            Object object4 = new double[0][0];
            boolean bl3 = ((Object)object).length > 1;
            boolean bl4 = bl2 = ((Object)object).length > 2;
            if (bl3) {
                object3 = object[1];
                if (bl2) {
                    object4 = object[2];
                }
            }
            int n = 0;
            while (n < ((Object)object2).length) {
                int n2 = 0;
                while (n2 < ((Object)object2[n]).length) {
                    xMLPrintWriter.print((double)object2[n][n2]);
                    if (bl3 && ((double[][])object3).length > n && object3[n].length > n2) {
                        xMLPrintWriter.print("," + object3[n][n2]);
                        if (bl2 && ((double[][])object4).length > n && object4[n].length > n2) {
                            xMLPrintWriter.println("," + object4[n][n2]);
                        } else {
                            xMLPrintWriter.println();
                        }
                    } else {
                        xMLPrintWriter.println();
                    }
                    ++n2;
                }
                ++n;
            }
            xMLPrintWriter.closeTag();
            xMLPrintWriter.printBinnedDataAxisAttributes("x", "" + this.getXMin(), "" + this.getXMax(), "" + this.dataSource.getXBins(), string);
            xMLPrintWriter.printBinnedDataAxisAttributes("y", "" + this.getYMin(), "" + this.getYMax(), "" + this.dataSource.getYBins(), string2);
        } else if (this.dataSource instanceof HasXMLRepresentation) {
            ((HasXMLRepresentation)((Object)this.dataSource)).writeAsXML(xMLPrintWriter);
        } else {
            if (this.dataSource instanceof HasDataSource) {
                xMLPrintWriter.setAttribute("name", this.dataSource.getClass().getName());
            } else {
                xMLPrintWriter.setAttribute("name", "???");
            }
            xMLPrintWriter.setAttribute("param", "???");
            xMLPrintWriter.printTag("class");
        }
        object = JASHist2DHistogramStyle.getHistStyleName(this.style.getHistStyle());
        xMLPrintWriter.setAttribute("histStyle", (String)object);
        if (((String)object).equals("STYLE_COLORMAP")) {
            xMLPrintWriter.setAttribute("colorMapScheme", JASHist2DHistogramStyle.getColorMapSchemeName(this.style.getColorMapScheme()));
        }
        xMLPrintWriter.setAttribute("shapeColor", ColorConverter.colorToString(this.style.getShapeColor()));
        xMLPrintWriter.setAttribute("overflowBinColor", ColorConverter.colorToString(this.style.getOverflowBinColor()));
        xMLPrintWriter.setAttribute("startDataColor", ColorConverter.colorToString(this.style.getStartDataColor()));
        xMLPrintWriter.setAttribute("endDataColor", ColorConverter.colorToString(this.style.getEndDataColor()));
        xMLPrintWriter.setAttribute("showOverflow", this.style.getShowOverflow());
        xMLPrintWriter.setAttribute("showPlot", this.style.getShowPlot());
        if (this.style.getLogZ()) {
            xMLPrintWriter.setAttribute("logZ", true);
        }
        xMLPrintWriter.printTag("style2d");
        xMLPrintWriter.closeTag();
    }

    boolean isRebinnable() {
        return this.dataSource.isRebinnable();
    }

    double getXMin() {
        double d = this.dataSource.getXMin();
        if (this.style.getShowOverflow()) {
            d -= (this.dataSource.getXMax() - d) / (double)this.dataSource.getXBins();
        }
        return d;
    }

    double getXMax() {
        double d = this.dataSource.getXMax();
        if (this.style.getShowOverflow()) {
            d += (d - this.dataSource.getXMin()) / (double)this.dataSource.getXBins();
        }
        return d;
    }

    double getYMin() {
        double d = this.dataSource.getYMin();
        if (this.style.getShowOverflow()) {
            d -= (this.dataSource.getYMax() - d) / (double)this.dataSource.getYBins();
        }
        return d;
    }

    double getYMax() {
        double d = this.dataSource.getYMax();
        if (this.style.getShowOverflow()) {
            d += (d - this.dataSource.getYMin()) / (double)this.dataSource.getYBins();
        }
        return d;
    }

    int getXBins() {
        return this.dataSource.getXBins();
    }

    int getYBins() {
        return this.dataSource.getYBins();
    }

    void setXRange(int n, double d, double d2) {
        if (this.isRebinnable()) {
            if (n != this.xBins || d != this.xLow || d2 != this.xHigh) {
                this.xBins = n;
                this.isBinned = false;
                this.zLimitsValid = false;
            }
        } else {
            this.xBins = this.dataSource.getXBins();
        }
        this.xLow = d;
        this.xHigh = d2;
    }

    void setYRange(int n, double d, double d2) {
        if (this.isRebinnable()) {
            if (n != this.yBins || d != this.yLow || d2 != this.yHigh) {
                this.yBins = n;
                this.isBinned = false;
                this.zLimitsValid = false;
            }
        } else {
            this.yBins = this.dataSource.getYBins();
        }
        this.yLow = d;
        this.yHigh = d2;
    }

    private void doBin() {
        this.isBinned = true;
        double[][][] dArray = this.dataSource.rebin(this.xBins, this.xLow, this.xHigh, this.yBins, this.yLow, this.yHigh, true, this.hurry, this.style.getShowOverflow());
        if (dArray == null) {
            dArray = new double[1][this.xBins][this.yBins];
        }
        if (this.normalization != null) {
            double d = 1.0 / this.normalization.getNormalizationFactor();
            int n = 0;
            while (n < dArray.length) {
                double[][] dArray2 = dArray[n];
                int n2 = 0;
                while (n2 < dArray2.length) {
                    double[] dArray3 = dArray2[n2];
                    int n3 = 0;
                    while (n3 < dArray3.length) {
                        int n4 = n3++;
                        dArray3[n4] = dArray3[n4] * d;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        this.data = dArray[0];
        if (this.data.length != this.xBins) {
            System.err.println("Warning xbins=" + this.xBins + " data.length=" + this.data.length);
        }
        if (this.overlay instanceof TwoDOverlay) {
            ((TwoDOverlay)this.overlay).setData(this.data, this.xLow, this.xHigh, this.yLow, this.yHigh, this.xBins, this.yBins);
        }
    }

    protected void calcZLimits() {
        double d;
        if (!this.isBinned) {
            this.doBin();
        }
        this.zLimitsValid = true;
        if (this.xBins == 0 || this.yBins == 0) {
            this.zMin = 0.0;
            d = Double.POSITIVE_INFINITY;
            this.zMax = 1.0;
        } else {
            d = Double.POSITIVE_INFINITY;
            this.zMin = Double.POSITIVE_INFINITY;
            this.zMax = Double.NEGATIVE_INFINITY;
            int n = 0;
            while (n < this.data[0].length) {
                int n2 = 0;
                while (n2 < this.data.length) {
                    double d2 = this.data[n2][n];
                    this.zMin = Math.min(this.zMin, d2);
                    if (d2 > 0.0) {
                        d = Math.min(d, d2);
                    }
                    this.zMax = Math.max(this.zMax, d2);
                    ++n2;
                }
                ++n;
            }
        }
        if (this.overlay instanceof TwoDOverlay) {
            ((TwoDOverlay)this.overlay).setZMinMax(this.zMin, this.zMax, d);
        }
    }

    public void update(Observable observable, Object object) {
        if (observable == this.dataSource) {
            HistogramUpdate histogramUpdate = (HistogramUpdate)object;
            this.isBinned = false;
            this.zLimitsValid = false;
            this.parent.update(histogramUpdate, this);
        } else if (observable == this.style) {
            this.isBinned = false;
            this.parent.styleUpdate(this);
        } else if (observable == this.normalization) {
            this.normalizationChanged(false);
        }
    }

    void normalizationChanged(boolean bl) {
        this.isBinned = false;
        this.zLimitsValid = false;
        this.parent.update(null, this);
    }

    public boolean hasChanged() {
        return !this.isBinned;
    }

    void validate() {
        if (!this.isBinned) {
            this.doBin();
        }
        System.out.println("validate called");
    }

    void axisChanged() {
        this.parent.axisChanged(this);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public JASHistStyle getStyle() {
        return this.style;
    }

    void destroy() {
        if (this.dataSource instanceof Observable) {
            ((Observable)((Object)this.dataSource)).deleteObserver(this);
        }
        this.style.deleteObserver(this);
        super.destroy();
    }
}

