/*
 * Decompiled with CFR 0.152.
 */
package Sct.TestFramework;

import Sct.File.ObjectManagerFile;
import Sct.Name;
import Sct.Serializable;
import Sct.SerializableWrapper;
import Sct.Streamable;
import Sct.TestFramework.DataCompare;
import Sct.TestFramework.TestObjectManager;
import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;

public abstract class StreamableTestCase
extends TestCase {
    public abstract Streamable getStreamable();

    protected boolean compare(Object object, Object object2) throws NoSuchFieldException {
        boolean bl = DataCompare.compare(object, object2);
        if (!bl) {
            Assert.fail((String)DataCompare.lastFailure.toString());
        }
        return bl;
    }

    public void testStreamable() throws IOException, NoSuchFieldException {
        Streamable streamable = this.getStreamable();
        TestObjectManager testObjectManager = new TestObjectManager();
        testObjectManager.writeStreamable(streamable);
        Streamable streamable2 = testObjectManager.readStreamable();
        Assert.assertTrue((boolean)this.compare(streamable, streamable2));
    }

    public void testViaFile() throws IOException, NoSuchFieldException {
        Streamable streamable = this.getStreamable();
        SerializableWrapper serializableWrapper = new SerializableWrapper(streamable);
        ObjectManagerFile objectManagerFile = ObjectManagerFile.getInstance();
        Name name = objectManagerFile.writeObject((Serializable)serializableWrapper);
        Streamable streamable2 = ((SerializableWrapper)objectManagerFile.readObject(name.getName())).get();
        Assert.assertTrue((boolean)this.compare(streamable, streamable2));
        new File(name.getName()).delete();
    }
}

