/*
 * Decompiled with CFR 0.152.
 */
package Sct.IS;

import Sct.IS.NameIS;
import Sct.OStream;
import Sct.ObjectManager;
import Sct.Serializable;
import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;

public class NameISTest
extends TestCase {
    public void testSerializableConstructor() {
        NameIS nameIS = new NameIS((Serializable)new SerializableDummy());
        this.compare(nameIS);
    }

    public void testStringsConstructor() {
        NameIS nameIS = new NameIS("Sct.IS.SerializableDummy", "SomeUniqueID.1.2.3");
        this.compare(nameIS);
    }

    public void testISNameConstructor() {
        NameIS nameIS = new NameIS("Default.Sct::IS::SerializableDummy.SomeUniqueID.1.2.3");
        this.compare(nameIS);
    }

    private void compare(NameIS nameIS) {
        Assert.assertEquals((String)"Sct.IS.SerializableDummy", (String)nameIS.getClassName());
        Assert.assertEquals((String)"SomeUniqueID.1.2.3", (String)nameIS.getUniqueID());
        Assert.assertEquals((String)"Default", (String)nameIS.getISServer());
        Assert.assertEquals((String)"Default.Sct::IS::SerializableDummy.SomeUniqueID.1.2.3", (String)nameIS.getName());
    }

    private class SerializableDummy
    implements Serializable {
        private SerializableDummy() {
        }

        public String getClassName() {
            return "Sct.IS.SerializableDummy";
        }

        public String getUniqueID() {
            return "SomeUniqueID.1.2.3";
        }

        public void write(OStream oStream, ObjectManager objectManager) throws IOException {
        }
    }
}

