/*
 * Decompiled with CFR 0.152.
 */
package Sct.File;

import Sct.File.NameFile;
import Sct.OStream;
import Sct.ObjectManager;
import Sct.Serializable;
import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;

public class NameFileTest
extends TestCase {
    public void testSerializableConstructor() {
        NameFile nameFile = new NameFile((Serializable)new SerializableDummy());
        this.compare(nameFile);
    }

    public void testStringsConstructor() {
        NameFile nameFile = new NameFile("Sct.File.SerializableDummy", "SomeUniqueID.1.2.3");
        this.compare(nameFile);
    }

    public void testFilenameConstructor() {
        NameFile nameFile = new NameFile("/tmp/Sct::File::SerializableDummy.SomeUniqueID.1.2.3");
        this.compare(nameFile);
    }

    public void testScratchDirProperty() {
        String string = "/tmp/myscratch/MyDir";
        System.getProperties().setProperty("Sct.Scratch.Dir", string);
        NameFile.reset();
        NameFile nameFile = new NameFile((Serializable)new SerializableDummy());
        this.compare(nameFile, string);
        NameFile nameFile2 = new NameFile("Sct.File.SerializableDummy", "SomeUniqueID.1.2.3");
        this.compare(nameFile2, string);
        NameFile nameFile3 = new NameFile(string + "/Sct::File::SerializableDummy.SomeUniqueID.1.2.3");
        this.compare(nameFile3, string);
    }

    private void compare(NameFile nameFile) {
        this.compare(nameFile, "/tmp");
    }

    private void compare(NameFile nameFile, String string) {
        Assert.assertEquals((String)"Sct.File.SerializableDummy", (String)nameFile.getClassName());
        Assert.assertEquals((String)"SomeUniqueID.1.2.3", (String)nameFile.getUniqueID());
        Assert.assertEquals((String)string, (String)nameFile.getPath());
        Assert.assertEquals((String)(string + "/Sct::File::SerializableDummy.SomeUniqueID.1.2.3"), (String)nameFile.getName());
    }

    private class SerializableDummy
    implements Serializable {
        private SerializableDummy() {
        }

        public String getClassName() {
            return "Sct.File.SerializableDummy";
        }

        public String getUniqueID() {
            return "SomeUniqueID.1.2.3";
        }

        public void write(OStream oStream, ObjectManager objectManager) throws IOException {
        }
    }
}

