/*
 * Decompiled with CFR 0.152.
 */
package SctApi.gui;

import Sct_SctApi.SctApi;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ProbeView
extends JFrame {
    SctApi api;
    JComponent information;
    JComponent control;
    short[] results;
    ControlWidgets ctlWidgets;

    public ProbeView(SctApi sctApi) {
        super("Scan");
        this.api = sctApi;
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProbeView.this.dispose();
            }
        });
        jPanel.add(jButton);
        this.getContentPane().add((Component)jPanel, "South");
        this.results = this.api.probeHarness(0, 0, 0, 0);
        this.updateResultsPanel();
        this.createControlPanel();
    }

    void updateResultsPanel() {
        if (this.information != null) {
            this.getContentPane().remove(this.information);
        }
        this.information = Box.createVerticalBox();
        int n = 0;
        while (n < this.results.length) {
            this.information.add(new JLabel("" + (char)this.results[n]));
            ++n;
        }
        this.getContentPane().add((Component)this.information, "North");
        this.information.invalidate();
        this.getContentPane().validate();
    }

    void createControlPanel() {
        this.control = Box.createVerticalBox();
        this.ctlWidgets = new ControlWidgets();
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("Partition"));
        this.ctlWidgets.partition = new JTextField("0");
        box.add(this.ctlWidgets.partition);
        box.add(new JLabel("Crate"));
        this.ctlWidgets.crate = new JTextField("0");
        box.add(this.ctlWidgets.crate);
        box.add(new JLabel("ROD"));
        this.ctlWidgets.rod = new JTextField("0");
        box.add(this.ctlWidgets.rod);
        box.add(new JLabel("Harness"));
        this.ctlWidgets.harness = new JTextField("0");
        box.add(this.ctlWidgets.harness);
        JButton jButton = new JButton("Probe");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = Integer.parseInt(ProbeView.this.ctlWidgets.partition.getText());
                int n2 = Integer.parseInt(ProbeView.this.ctlWidgets.crate.getText());
                int n3 = Integer.parseInt(ProbeView.this.ctlWidgets.rod.getText());
                int n4 = Integer.parseInt(ProbeView.this.ctlWidgets.harness.getText());
                ProbeView.this.results = ProbeView.this.api.probeHarness(n, n2, n3, n4);
                ProbeView.this.updateResultsPanel();
            }
        });
        box.add(jButton);
        this.control.add(box);
        this.getContentPane().add((Component)this.control, "Center");
    }

    class ControlWidgets {
        JTextField partition;
        JTextField crate;
        JTextField rod;
        JTextField harness;

        ControlWidgets() {
        }
    }
}

