/*
 * Decompiled with CFR 0.152.
 */
package SctApi.gui;

import Sct_SctApi.Scan;
import Sct_SctApi.ScanPackage.ScanOptions;
import Sct_SctApi.SctApi;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class ScanView
extends JFrame {
    SctApi api;
    Scan scan;
    JComponent information;
    JComponent control;
    ControlWidgets ctlWidgets;

    public ScanView(SctApi sctApi, Scan scan) {
        super("Scan");
        this.api = sctApi;
        this.scan = scan;
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Print Scan");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScanView.this.scan.print();
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Execute Scan");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScanView.this.api.doScan(ScanView.this.scan);
            }
        });
        jPanel.add(jButton2);
        JButton jButton3 = new JButton("Close");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScanView.this.dispose();
            }
        });
        jPanel.add(jButton3);
        JButton jButton4 = new JButton("Destroy");
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScanView.this.scan.destroy();
                ScanView.this.dispose();
            }
        });
        jPanel.add(jButton4);
        this.getContentPane().add((Component)jPanel, "South");
        this.updateInfoPanel();
        this.createControlPanel();
    }

    void updateInfoPanel() {
        if (this.information != null) {
            this.getContentPane().remove(this.information);
        }
        this.information = Box.createVerticalBox();
        this.information.add(new JLabel("ScanVariable1: " + this.scan.getScanVariable1()));
        this.information.add(new JLabel("ScanVariable2: " + this.scan.getScanVariable2()));
        this.information.add(new JLabel("NTrigs: " + this.scan.getNTrigs()));
        String string = "";
        string = string + " format: " + this.scan.getOption(ScanOptions.format);
        string = string + " full: " + this.scan.getOption(ScanOptions.full);
        string = string + " bits32: " + this.scan.getOption(ScanOptions.bits32);
        string = string + " loopCalLine: " + this.scan.getOption(ScanOptions.loopCalLine);
        string = string + " distSlave: " + this.scan.getOption(ScanOptions.distSlave);
        string = string + " debug: " + this.scan.getOption(ScanOptions.debug);
        this.information.add(new JLabel(string));
        double[] dArray = this.scan.getScanPoints1();
        Object[] objectArray = new Object[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            objectArray[n] = new String("" + dArray[n]);
            ++n;
        }
        JList<Object> jList = new JList<Object>(objectArray);
        this.information.add(new JScrollPane(jList, 20, 31));
        this.getContentPane().add((Component)this.information, "North");
        this.information.invalidate();
        this.getContentPane().validate();
    }

    void createControlPanel() {
        this.control = Box.createVerticalBox();
        this.ctlWidgets = new ControlWidgets();
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("Scan type1"));
        this.ctlWidgets.type1 = new JTextField("1");
        box.add(this.ctlWidgets.type1);
        box.add(new JLabel("Start scan 1 value"));
        this.ctlWidgets.start1 = new JTextField("0.0");
        box.add(this.ctlWidgets.start1);
        box.add(new JLabel("Stop scan 1 value"));
        this.ctlWidgets.stop1 = new JTextField("100.0");
        box.add(this.ctlWidgets.stop1);
        box.add(new JLabel("Step scan 1 value"));
        this.ctlWidgets.step1 = new JTextField("10.0");
        box.add(this.ctlWidgets.step1);
        JButton jButton = new JButton("Update scan 1");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                short s = Short.parseShort(ScanView.this.ctlWidgets.type1.getText());
                double d = Double.parseDouble(ScanView.this.ctlWidgets.start1.getText());
                double d2 = Double.parseDouble(ScanView.this.ctlWidgets.stop1.getText());
                double d3 = Double.parseDouble(ScanView.this.ctlWidgets.step1.getText());
                System.out.println("Configuring scan with " + s + " " + d + " " + d2 + " " + d3);
                ScanView.this.scan.configure(s, d, d2, d3);
                ScanView.this.updateInfoPanel();
            }
        });
        box.add(jButton);
        this.control.add(box);
        Box box2 = Box.createHorizontalBox();
        box2.add(new JLabel("Scan type2"));
        this.ctlWidgets.type2 = new JTextField("1");
        box2.add(this.ctlWidgets.type2);
        box2.add(new JLabel("Start scan 2 value"));
        this.ctlWidgets.start2 = new JTextField("0.0");
        box2.add(this.ctlWidgets.start2);
        box2.add(new JLabel("Stop scan 2 value"));
        this.ctlWidgets.stop2 = new JTextField("100.0");
        box2.add(this.ctlWidgets.stop2);
        box2.add(new JLabel("Step scan 2 value"));
        this.ctlWidgets.step2 = new JTextField("10.0");
        box2.add(this.ctlWidgets.step2);
        JButton jButton2 = new JButton("Update scan 2");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                short s = Short.parseShort(ScanView.this.ctlWidgets.type2.getText());
                double d = Double.parseDouble(ScanView.this.ctlWidgets.start2.getText());
                double d2 = Double.parseDouble(ScanView.this.ctlWidgets.stop2.getText());
                double d3 = Double.parseDouble(ScanView.this.ctlWidgets.step2.getText());
                System.out.println("Configuring scan with " + s + " " + d + " " + d2 + " " + d3);
                ScanView.this.scan.configure2(s, d, d2, d3);
                ScanView.this.updateInfoPanel();
            }
        });
        box2.add(jButton2);
        this.control.add(box2);
        Box box3 = Box.createHorizontalBox();
        box3.add(new JLabel("No. Triggers"));
        this.ctlWidgets.ntrigs = new JTextField("100");
        box3.add(this.ctlWidgets.ntrigs);
        box3.add(new JLabel("Format"));
        this.ctlWidgets.format = new JTextField("0");
        box3.add(this.ctlWidgets.format);
        box3.add(new JLabel("Bits32"));
        this.ctlWidgets.bits32 = new JTextField("1");
        box3.add(this.ctlWidgets.bits32);
        box3.add(new JLabel("Loop over calLine"));
        this.ctlWidgets.loopCalLine = new JTextField("0");
        box3.add(this.ctlWidgets.loopCalLine);
        box3.add(new JLabel("Slave distribution"));
        this.ctlWidgets.distSlave = new JTextField("0");
        box3.add(this.ctlWidgets.distSlave);
        JButton jButton3 = new JButton("Update");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                short s = Short.parseShort(ScanView.this.ctlWidgets.ntrigs.getText());
                ScanView.this.scan.setNTrigs(s);
                short s2 = Short.parseShort(ScanView.this.ctlWidgets.format.getText());
                ScanView.this.scan.setOption(ScanOptions.format, s2);
                short s3 = Short.parseShort(ScanView.this.ctlWidgets.bits32.getText());
                ScanView.this.scan.setOption(ScanOptions.bits32, s3);
                short s4 = Short.parseShort(ScanView.this.ctlWidgets.loopCalLine.getText());
                ScanView.this.scan.setOption(ScanOptions.loopCalLine, s4);
                short s5 = Short.parseShort(ScanView.this.ctlWidgets.distSlave.getText());
                ScanView.this.scan.setOption(ScanOptions.distSlave, s5);
                ScanView.this.updateInfoPanel();
            }
        });
        box3.add(jButton3);
        this.control.add(box3);
        this.getContentPane().add((Component)this.control, "Center");
    }

    class ControlWidgets {
        JTextField type1;
        JTextField start1;
        JTextField stop1;
        JTextField step1;
        JTextField type2;
        JTextField start2;
        JTextField stop2;
        JTextField step2;
        JTextField ntrigs;
        JTextField format;
        JTextField full;
        JTextField bits32;
        JTextField loopCalLine;
        JTextField distSlave;
        JTextField debug;

        ControlWidgets() {
        }
    }
}

