/*
 * Decompiled with CFR 0.152.
 */
package SctApi.gui;

import SctApi.gui.ProbeView;
import SctApi.gui.ScanList;
import SctApi.gui.ScanView;
import Sct_SctApi.Scan;
import Sct_SctApi.SctApi;
import Sct_SctApi.SctApiHelper;
import ipc.Partition;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.Object;

public class ScanGui
extends JFrame {
    private SctApi api;
    private final ScanGui finalGui = this;

    public static void main(String[] stringArray) {
        System.out.println("Hello world");
        ScanGui scanGui = new ScanGui();
        scanGui.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        scanGui.pack();
        scanGui.setVisible(true);
    }

    public ScanGui() {
        super("SCTAPI Scan GUI");
        java.lang.Object object;
        Partition partition = new Partition("SCT");
        try {
            object = partition.lookup("SCTSctApiServer", "Test_Server");
            if (object == null) {
                System.out.println("Object SCTSctApiServer not found in server Test_Server");
            } else {
                this.api = SctApiHelper.narrow((Object)object);
            }
        }
        catch (BAD_PARAM bAD_PARAM) {
            System.err.println("Couldn't get api object: " + (java.lang.Object)((java.lang.Object)bAD_PARAM));
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            System.err.println("CORBA communications error: " + (java.lang.Object)((java.lang.Object)cOMM_FAILURE));
        }
        catch (Exception exception) {
            System.err.println("Other error" + exception);
        }
        if (this.api == null) {
            System.err.println("Error (check SCTAPI running)");
            System.exit(0);
        }
        System.out.println("Found SCTAPI");
        object = new JPanel();
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScanGui.this.dispose();
            }
        });
        ((Container)object).add(jButton);
        JButton jButton2 = new JButton("Shutdown server");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("Shutdown system");
                ScanGui.this.api.shutdownAll();
                System.out.println("Done");
                ScanGui.this.api.destroy();
                ScanGui.this.dispose();
                System.exit(0);
            }
        });
        ((Container)object).add(jButton2);
        JButton jButton3 = new JButton("Probe Modules");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProbeView probeView = new ProbeView(ScanGui.this.api);
                probeView.addWindowListener(new WindowAdapter(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void windowClosing(WindowEvent windowEvent) {
                        windowEvent.getWindow().dispose();
                    }
                });
                probeView.pack();
                probeView.setVisible(true);
            }
        });
        ((Container)object).add(jButton3);
        JButton jButton4 = new JButton("New scan");
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Scan scan = ScanGui.this.api.defaultScan();
                scan.configure((short)1, 0.0, 100.0, 10.0);
                scan.setNTrigs(1000);
                scan.getTrigger1().singleL1A();
                ScanView scanView = new ScanView(ScanGui.this.api, scan);
                scanView.addWindowListener(new WindowAdapter(this){
                    private final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void windowClosing(WindowEvent windowEvent) {
                        windowEvent.getWindow().dispose();
                    }
                });
                scanView.pack();
                scanView.setVisible(true);
            }
        });
        ((Container)object).add(jButton4);
        JButton jButton5 = new JButton("List scans");
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Scan[] scanArray = ScanGui.this.api.knownScans();
                ScanList scanList = new ScanList(ScanGui.this.api, scanArray);
                scanList.addWindowListener(new WindowAdapter(this){
                    private final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void windowClosing(WindowEvent windowEvent) {
                        windowEvent.getWindow().dispose();
                    }
                });
                scanList.pack();
                scanList.setVisible(true);
            }
        });
        ((Container)object).add(jButton5);
        JButton jButton6 = new JButton("Show status");
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScanGui.this.api.status();
            }
        });
        ((Container)object).add(jButton6);
        this.getContentPane().add((Component)object, "South");
        System.out.println("Set up GUI, wait for it to run");
    }
}

