/*
 * Decompiled with CFR 0.152.
 */
package GuiComponents.scripting;

import GuiComponents.Console.JConsole;
import GuiComponents.scripting.DefaultInterpreter;
import GuiComponents.scripting.NameCompleter;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;

public class JythonInterpreter
extends DefaultInterpreter {
    private int lastLevel = 0;

    public JythonInterpreter(JConsole jConsole, BSFEngine bSFEngine, NameCompleter nameCompleter) {
        super(jConsole, bSFEngine, nameCompleter);
        this.lineContinueChar = (char)92;
        this.blockStartChar = (char)58;
    }

    protected boolean endBlock(String string) {
        return this.indentLevel(string) < this.nestLevel();
    }

    private int indentLevel(String string) {
        this.lastLevel = 0;
        while (string.charAt(this.lastLevel) == '\t') {
            ++this.lastLevel;
        }
        return this.lastLevel;
    }

    protected void decIndent() {
        int n = this.nestLevel() - this.lastLevel;
        System.out.println(n);
        while (n-- > 0) {
            super.decIndent();
        }
    }

    public void exec(String string, String string2, int n, int n2) {
        try {
            Object object = this.engine.eval(string2, n, n2, (Object)string);
            if (this.printObject(object)) {
                this.console.println(object.toString());
            }
        }
        catch (BSFException bSFException) {
            try {
                this.engine.exec(string2, n, n2, (Object)string);
            }
            catch (BSFException bSFException2) {
                this.console.println(bSFException2.toString());
                bSFException2.printStackTrace();
            }
        }
    }
}

