/*
 * Decompiled with CFR 0.152.
 */
package GuiComponents.System;

import AnalysisServiceI.AnalysisServiceInterface;
import AnalysisServiceI.AnalysisServiceInterfaceHelper;
import FitterI.FitterInterface;
import FitterI.FitterInterfaceHelper;
import SctApiTest.sctapi;
import SctApiTest.sctapiHelper;
import Sct_CalibrationController.CalibrationController;
import Sct_CalibrationController.CalibrationControllerHelper;
import Sct_SctApi.SctApi;
import Sct_SctApi.SctApiHelper;
import ipc.Partition;
import java.util.logging.Logger;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import sctConf.Configuration;
import sctConf.ConfigurationHelper;

public class SystemInterface {
    private static SystemInterface instance = new SystemInterface();
    private static final String partitionName = "SCT";
    private Partition p;
    private Logger logger = Logger.getLogger("GuiComponents.System");
    private sctapi testapi;
    private CalibrationController cc;
    private SctApi api;
    private Configuration config;
    private AnalysisServiceInterface analysis;
    private FitterInterface fitter;

    public static SystemInterface getInstance() {
        return instance;
    }

    public void refresh() {
        this.p = new Partition(partitionName);
        this.testapi = null;
        this.cc = null;
        this.api = null;
        this.config = null;
        this.analysis = null;
        this.fitter = null;
    }

    public Partition getPartition() {
        return this.p;
    }

    public sctapi getTestApi() {
        block3: {
            if (this.testapi != null) break block3;
            try {
                Object object = this.p.lookup("SCTTestAPIServerImpl", "SCTTestAPIServer");
                this.testapi = sctapiHelper.narrow((Object)object);
                if (this.testapi == null) {
                    this.logger.info("Failed to lookup SCTTestAPI using: SCTTestAPIServerImpl and SCTTestAPIServer.");
                }
            }
            catch (SystemException systemException) {
                this.logger.info("Failed to lookup SCTTestAPI using: SCTTestAPIServerImpl and SCTTestAPIServer. Exception: " + systemException.getMessage());
            }
        }
        return this.testapi;
    }

    public CalibrationController getCalibrationController() {
        block2: {
            if (this.cc != null) break block2;
            try {
                Object object = this.p.lookup("CalibrationControllerImpl", "CalibrationControllerServer");
                this.cc = CalibrationControllerHelper.narrow(object);
            }
            catch (SystemException systemException) {
                this.logger.info("Failed to lookup CalibrationController using: CalibrationControllerImpl and CalibrationControllerServer. Exception: " + systemException.getMessage());
            }
        }
        return this.cc;
    }

    public SctApi getSctApi() {
        block2: {
            if (this.api != null) break block2;
            try {
                Object object = this.p.lookup("SCTSctApiServer", "Test_Server");
                this.api = SctApiHelper.narrow((Object)object);
            }
            catch (SystemException systemException) {
                this.logger.info("Failed to lookup AnalysisService using: SCTSctApiServer and Test_Server . Exception: " + systemException.getMessage());
            }
        }
        return this.api;
    }

    public Configuration getConfigurationService() {
        block2: {
            if (this.config != null) break block2;
            try {
                Object object = this.p.lookup("SCTConfigurationServer", "Test_Server");
                this.config = ConfigurationHelper.narrow((Object)object);
            }
            catch (SystemException systemException) {
                this.logger.info("Failed to lookup Configuration using: SCTConfigurationServer and Test_Server. Exception: " + systemException.getMessage());
            }
        }
        return this.config;
    }

    public AnalysisServiceInterface getAnalysisService() {
        block2: {
            if (this.analysis != null) break block2;
            try {
                Object object = this.p.lookup("AnalysisServiceImpl", "AnalysisService");
                this.analysis = AnalysisServiceInterfaceHelper.narrow(object);
            }
            catch (SystemException systemException) {
                this.logger.info("Failed to lookup AnalysisService using: AnalysisServiceImpl and AnalysisService. Exception: " + systemException.getMessage());
            }
        }
        return this.analysis;
    }

    public FitterInterface getFittingService() {
        block2: {
            if (this.fitter != null) break block2;
            try {
                Object object = this.p.lookup("FittingServiceImpl", "FittingService");
                this.fitter = FitterInterfaceHelper.narrow((Object)object);
            }
            catch (SystemException systemException) {
                this.logger.info("Failed to lookup Fitter using: FittingServiceImpl and FittingService. Exception: " + systemException.getMessage());
            }
        }
        return this.fitter;
    }

    private SystemInterface() {
        this.refresh();
    }
}

