/*
 * Decompiled with CFR 0.152.
 */
package GuiComponents.Console;

import GuiComponents.Console.NameCompletionListener;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class JConsole
extends JScrollPane
implements KeyListener,
ActionListener,
PropertyChangeListener,
MouseListener {
    protected JEditorPane tpText;
    protected JPopupMenu mPopup;
    protected String sPrompt;
    protected String sPostPrompt;
    protected char cEnterChar = (char)10;
    private int startPos = 0;
    protected Vector vListeners = new Vector();
    protected Vector nameListeners = new Vector();
    protected Vector vHistory = new Vector();
    private int historyPos = 0;
    private String curCmd;
    protected AbstractDocument doc;
    private static final String CUT = "Cut";
    private static final String COPY = "Copy";
    private static final String PASTE = "Paste";

    public JConsole() {
        this.initComponents();
        this.requestFocus();
    }

    protected void initComponents() {
        this.doc = new PlainDocument(){

            public void remove(int n, int n2) throws BadLocationException {
                if (n >= JConsole.this.startPos) {
                    super.remove(n, n2);
                }
            }
        };
        this.doc.setAsynchronousLoadPriority(1);
        this.tpText = new JEditorPane(){

            public void cut() {
                if (JConsole.this.tpText.getCaretPosition() < JConsole.this.startPos) {
                    super.copy();
                } else {
                    super.cut();
                }
            }

            public void paste() {
                JConsole.this.moveCaretToEnd();
                super.paste();
            }
        };
        this.tpText.setDocument(this.doc);
        Font font = new Font("Monospaced", 0, 14);
        this.tpText.setText("");
        this.tpText.setFont(font);
        this.tpText.setMargin(new Insets(7, 5, 7, 5));
        this.tpText.addKeyListener(this);
        this.setViewportView(this.tpText);
        this.tpText.setDoubleBuffered(true);
        this.mPopup = new JPopupMenu("JConsole Menu");
        this.mPopup.add(new JMenuItem(CUT)).addActionListener(this);
        this.mPopup.add(new JMenuItem(COPY)).addActionListener(this);
        this.mPopup.add(new JMenuItem(PASTE)).addActionListener(this);
        this.tpText.addMouseListener(this);
        UIManager.addPropertyChangeListener(this);
    }

    public void initialize() {
        this.resetCommandStart();
    }

    public InputStream getInputStream() {
        return new ActionStream(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CUT)) {
            this.tpText.cut();
        } else if (string.equals(COPY)) {
            this.tpText.copy();
        } else if (string.equals(PASTE)) {
            this.tpText.paste();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 38: {
                if (keyEvent.getID() == 401) {
                    this.historyUp();
                }
                keyEvent.consume();
                break;
            }
            case 40: {
                if (keyEvent.getID() == 401) {
                    this.historyDown();
                }
                keyEvent.consume();
                break;
            }
            case 8: 
            case 37: 
            case 127: {
                if (this.tpText.getCaretPosition() > this.startPos) break;
                keyEvent.consume();
                break;
            }
            case 35: {
                this.moveCaretToEnd();
                keyEvent.consume();
                break;
            }
            case 36: {
                this.moveCaretToStart();
                keyEvent.consume();
                break;
            }
            case 67: {
                break;
            }
            case 9: 
            case 10: {
                keyEvent.consume();
                break;
            }
            default: {
                if (this.tpText.getCaretPosition() > this.startPos) break;
                this.moveCaretToEnd();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == this.cEnterChar) {
            this.enter();
            keyEvent.consume();
        }
        if (keyEvent.getKeyChar() == '\t') {
            this.nameCompletionEvent();
            keyEvent.consume();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.showMenu(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.showMenu(mouseEvent);
    }

    private void showMenu(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.mPopup.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this.mPopup);
        }
    }

    protected void moveCaretToEnd() {
        this.tpText.setCaretPosition(this.doc.getLength());
    }

    protected void moveCaretToStart() {
        this.tpText.setCaretPosition(this.startPos);
    }

    public void addActionListener(ActionListener actionListener) {
        this.vListeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.vListeners.remove(actionListener);
    }

    public void addNameCompletionListener(NameCompletionListener nameCompletionListener) {
        this.nameListeners.add(nameCompletionListener);
    }

    public void removeNameCompletionListener(NameCompletionListener nameCompletionListener) {
        this.nameListeners.remove(nameCompletionListener);
    }

    protected void nameCompletionEvent() {
        int n = 0;
        while (n < this.nameListeners.size()) {
            ((NameCompletionListener)this.nameListeners.get(n)).completeName(this.getCmd());
            ++n;
        }
    }

    public void resetCommandStart() {
        this.append(this.sPrompt);
        this.startPos = this.tpText.getText().length();
        this.append(this.sPostPrompt);
    }

    public void append(String string) {
        try {
            this.doc.insertString(this.doc.getLength(), string, null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    String replaceRange(Object object, int n, int n2) {
        String string = object.toString();
        this.tpText.select(n, n2);
        this.tpText.replaceSelection(string);
        return string;
    }

    protected void enter() {
        String string = this.getCmd();
        if (string.length() == 0) {
            string = "\n";
        } else {
            this.vHistory.addElement(string);
            string = string + "\n";
        }
        this.append("\n");
        this.historyPos = 0;
        this.dispatchEvent(string);
        this.resetCommandStart();
    }

    private String getCmd() {
        String string = "";
        try {
            string = this.tpText.getText(this.startPos, this.tpText.getText().length() - this.startPos);
        }
        catch (BadLocationException badLocationException) {
            System.out.println("Internal Error: JConsole getCmd: " + badLocationException);
        }
        return string;
    }

    protected void dispatchEvent(String string) {
        ActionEvent actionEvent = new ActionEvent(this, 1001, string);
        int n = 0;
        while (n < this.vListeners.size()) {
            ((ActionListener)this.vListeners.get(n)).actionPerformed(actionEvent);
            ++n;
        }
    }

    public String getPrompt() {
        return this.sPrompt;
    }

    public void setPrompt(String string) {
        this.sPrompt = string;
    }

    public String getPostPrompt() {
        return this.sPostPrompt;
    }

    public void setPostPrompt(String string) {
        this.sPostPrompt = string;
    }

    protected void historyUp() {
        if (this.vHistory.size() == 0) {
            return;
        }
        if (this.historyPos == 0) {
            this.curCmd = this.getCmd();
        }
        if (this.historyPos < this.vHistory.size()) {
            ++this.historyPos;
            this.showHistoryLine();
        }
    }

    protected void historyDown() {
        if (this.historyPos == 0) {
            return;
        }
        --this.historyPos;
        this.showHistoryLine();
    }

    protected void showHistoryLine() {
        String string = this.historyPos == 0 ? this.curCmd : (String)this.vHistory.elementAt(this.vHistory.size() - this.historyPos);
        this.replaceRange(string, this.startPos, this.tpText.getText().length());
        this.moveCaretToEnd();
        this.tpText.repaint();
    }

    public String toString() {
        return "JConsole";
    }

    public void println(String string) {
        this.print(string + "\n");
    }

    public void print(String string) {
        this.append(string == null ? "null" : string);
        this.moveCaretToEnd();
    }

    public void println() {
        this.print("\n");
    }

    public void println(Object object) {
        this.print(new StringBuffer(String.valueOf(object)).append("\n"));
    }

    public void print(Object object) {
        this.print(String.valueOf(object));
    }

    class ActionStream
    extends InputStream
    implements ActionListener {
        protected JConsole console;
        protected List list;
        private byte[] current;
        private int pos;

        public ActionStream(JConsole jConsole2) {
            this.console = jConsole2;
            jConsole2.addActionListener(this);
            this.list = Collections.synchronizedList(new LinkedList());
        }

        public synchronized void actionPerformed(ActionEvent actionEvent) {
            this.list.add(actionEvent.getActionCommand());
        }

        public void close() throws IOException {
            this.console.removeActionListener(this);
        }

        /*
         * Unable to fully structure code
         */
        public int read() throws IOException {
            block3: {
                if (this.current != null && this.pos != this.current.length) break block3;
                if (this.list.size() <= 0) ** GOTO lbl13
                this.current = ((String)this.list.get(0)).getBytes();
                this.pos = 0;
                break block3;
lbl-1000:
                // 1 sources

                {
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException var1_1) {
                        // empty catch block
                    }
lbl13:
                    // 3 sources

                    ** while (this.list.size() == 0)
                }
            }
            return this.current[this.pos++];
        }
    }
}

